/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql.jdb;

import io.apicurio.registry.storage.impl.sql.jdb.RuntimeSqlException;
import io.apicurio.registry.storage.impl.sql.jdb.SqlParamType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class SqlParam {
    private final int position;
    private final Object value;
    private final SqlParamType type;

    public SqlParam(int position, Object value, SqlParamType type) {
        this.position = position;
        this.value = value;
        this.type = type;
    }

    public void bindTo(PreparedStatement statement) {
        int position = this.position + 1;
        try {
            switch (this.type) {
                case BYTES: {
                    statement.setBytes(position, (byte[])this.value);
                    break;
                }
                case DATE: {
                    if (this.value == null) {
                        statement.setNull(position, 93);
                        break;
                    }
                    Timestamp ts = new Timestamp(((Date)this.value).getTime());
                    statement.setTimestamp(position, ts);
                    break;
                }
                case ENUM: {
                    if (this.value == null) {
                        statement.setNull(position, 12);
                        break;
                    }
                    statement.setString(position, ((Enum)this.value).name());
                    break;
                }
                case INTEGER: {
                    if (this.value == null) {
                        statement.setNull(position, 4);
                        break;
                    }
                    statement.setInt(position, (Integer)this.value);
                    break;
                }
                case LONG: {
                    if (this.value == null) {
                        statement.setNull(position, 4);
                        break;
                    }
                    statement.setLong(position, (Long)this.value);
                    break;
                }
                case STRING: {
                    statement.setString(position, (String)this.value);
                    break;
                }
                default: {
                    throw new RuntimeSqlException("bindTo not supported for SqlParamType: " + this.type);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }
}

