/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql.upgrader;

import io.apicurio.registry.storage.impl.sql.IDbUpgrader;
import io.apicurio.registry.storage.impl.sql.jdb.Handle;
import io.apicurio.registry.storage.impl.sql.jdb.Update;
import io.apicurio.registry.storage.impl.sql.mappers.ContentEntityMapper;
import io.apicurio.registry.utils.impexp.ContentEntity;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterForReflection
public class ReferencesContentHashUpgrader
implements IDbUpgrader {
    private static Logger logger = LoggerFactory.getLogger(ReferencesContentHashUpgrader.class);

    @Override
    public void upgrade(Handle dbHandle) throws Exception {
        Stream<ContentEntity> stream;
        String sql = "SELECT c.contentId, c.content, c.canonicalHash, c.contentHash, c.artifactreferences FROM versions v JOIN content c on c.contentId = v.contentId JOIN artifacts a ON v.tenantId = a.tenantId AND v.groupId = a.groupId AND v.artifactId = a.artifactId ";
        try (Stream<ContentEntity> stream2 = stream = dbHandle.createQuery(sql).setFetchSize(50).map(ContentEntityMapper.instance).stream();){
            stream.forEach(entity -> this.updateHash((ContentEntity)entity, dbHandle));
        }
    }

    private void updateHash(ContentEntity contentEntity, Handle dbHandle) {
        try {
            if (contentEntity.serializedReferences != null) {
                byte[] referencesBytes = contentEntity.serializedReferences.getBytes(StandardCharsets.UTF_8);
                String contentHash = DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(contentEntity.contentBytes, referencesBytes));
                String update = "UPDATE content SET contentHash = ? WHERE contentId = ? AND contentHash = ?";
                int rowCount = ((Update)((Update)((Update)dbHandle.createUpdate(update).bind(0, contentHash)).bind(1, contentEntity.contentId)).bind(2, contentEntity.contentHash)).execute();
                if (rowCount == 0) {
                    logger.warn("content row not matched for hash upgrade contentId {} contentHash {}", (Object)contentEntity.contentId, (Object)contentEntity.contentHash);
                }
            }
        }
        catch (IOException e) {
            logger.warn("Error found processing content with id {} and hash {}", new Object[]{contentEntity.contentId, contentEntity.contentHash, e});
        }
    }

    private byte[] concatContentAndReferences(byte[] contentBytes, byte[] referencesBytes) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(contentBytes.length + referencesBytes.length);
        outputStream.write(contentBytes);
        outputStream.write(referencesBytes);
        return outputStream.toByteArray();
    }
}

