/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.metrics;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.quarkus.runtime.StartupEvent;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@ApplicationScoped
public class StorageMetricsStore {
    @Inject
    Logger log;
    @Inject
    @ConfigProperty(defaultValue="30000", name="registry.storage.metrics.cache.check-period")
    @Info(category="health", description="Storage metrics cache check period", availableSince="2.1.0.Final")
    Long limitsCheckPeriod;
    @Inject
    @ConfigProperty(defaultValue="1000", name="registry.storage.metrics.cache.max-size")
    @Info(category="limits", description="Storage metrics cache max size.", availableSince="2.4.1.Final")
    Long cacheMaxSize;
    @Inject
    TenantContext tenantContext;
    @Inject
    @Current
    RegistryStorage storage;
    private LoadingCache<String, AtomicLong> totalSchemasCounters;
    private LoadingCache<String, AtomicLong> artifactsCounters;
    private LoadingCache<ArtifactVersionKey, AtomicLong> artifactVersionsCounters;
    CacheLoader<String, AtomicLong> totalSchemaCountersLoader;
    CacheLoader<String, AtomicLong> artifactsCountersLoader;
    CacheLoader<ArtifactVersionKey, AtomicLong> artifactVersionsCountersLoader;

    public void onStart(@Observes StartupEvent ev) {
        this.createTotalSchemasCache();
        this.createTotalArtifactsCache();
        this.createTotalArtifactVersionsCache();
    }

    private void createTotalSchemasCache() {
        this.totalSchemaCountersLoader = new CacheLoader<String, AtomicLong>(){

            public AtomicLong load(@NotNull String tenantId) {
                StorageMetricsStore.this.log.info("Initializing total schemas counter, tid {}", (Object)StorageMetricsStore.this.tenantContext.tenantId());
                long count = StorageMetricsStore.this.storage.countTotalArtifactVersions();
                return new AtomicLong(count);
            }
        };
        this.totalSchemasCounters = CacheBuilder.newBuilder().expireAfterWrite(this.limitsCheckPeriod.longValue(), TimeUnit.MILLISECONDS).maximumSize(this.cacheMaxSize.longValue()).build(this.totalSchemaCountersLoader);
    }

    private void createTotalArtifactsCache() {
        this.artifactsCountersLoader = new CacheLoader<String, AtomicLong>(){

            public AtomicLong load(@NotNull String tenantId) {
                StorageMetricsStore.this.log.info("Initializing total artifacts counter, tid {}", (Object)StorageMetricsStore.this.tenantContext.tenantId());
                long count = StorageMetricsStore.this.storage.countArtifacts();
                return new AtomicLong(count);
            }
        };
        this.artifactsCounters = CacheBuilder.newBuilder().expireAfterWrite(this.limitsCheckPeriod.longValue(), TimeUnit.MILLISECONDS).maximumSize(this.cacheMaxSize.longValue()).build(this.artifactsCountersLoader);
    }

    private void createTotalArtifactVersionsCache() {
        this.artifactVersionsCountersLoader = new CacheLoader<ArtifactVersionKey, AtomicLong>(){

            public AtomicLong load(@NotNull ArtifactVersionKey artifactVersionKey) {
                StorageMetricsStore.this.log.info("Initializing total artifact versions counter for artifact gid {} ai {}, tid {}", new Object[]{artifactVersionKey.groupId, artifactVersionKey.artifactId, StorageMetricsStore.this.tenantContext.tenantId()});
                long count = StorageMetricsStore.this.storage.countArtifactVersions(artifactVersionKey.groupId, artifactVersionKey.artifactId);
                return new AtomicLong(count);
            }
        };
        this.artifactVersionsCounters = CacheBuilder.newBuilder().expireAfterWrite(this.limitsCheckPeriod.longValue(), TimeUnit.MILLISECONDS).maximumSize(this.cacheMaxSize.longValue()).build(this.artifactVersionsCountersLoader);
    }

    public long getOrInitializeTotalSchemasCounter() {
        return ((AtomicLong)this.totalSchemasCounters.getUnchecked((Object)this.tenantContext.tenantId())).get();
    }

    public long getOrInitializeArtifactsCounter() {
        return ((AtomicLong)this.artifactsCounters.getUnchecked((Object)this.tenantContext.tenantId())).get();
    }

    public long getOrInitializeArtifactVersionsCounter(String groupId, String artifactId) {
        ArtifactVersionKey avk = new ArtifactVersionKey();
        avk.tenantId = this.tenantContext.tenantId();
        avk.groupId = groupId;
        avk.artifactId = artifactId;
        return ((AtomicLong)this.artifactVersionsCounters.getUnchecked((Object)avk)).get();
    }

    public void incrementTotalSchemasCounter() {
        this.log.info("Incrementing total schemas counter, tid {}", (Object)this.tenantContext.tenantId());
        AtomicLong counter = (AtomicLong)this.totalSchemasCounters.getUnchecked((Object)this.tenantContext.tenantId());
        if (counter == null) {
            return;
        }
        counter.incrementAndGet();
    }

    public void incrementArtifactsCounter() {
        AtomicLong counter = (AtomicLong)this.artifactsCounters.getUnchecked((Object)this.tenantContext.tenantId());
        if (counter == null) {
            return;
        }
        counter.incrementAndGet();
    }

    public void incrementArtifactVersionsCounter(String groupId, String artifactId) {
        ArtifactVersionKey avk = new ArtifactVersionKey();
        avk.tenantId = this.tenantContext.tenantId();
        avk.groupId = groupId;
        avk.artifactId = artifactId;
        AtomicLong counter = (AtomicLong)this.artifactVersionsCounters.getUnchecked((Object)avk);
        if (counter == null) {
            return;
        }
        counter.incrementAndGet();
    }

    public void resetTotalSchemasCounter() {
        this.totalSchemasCounters.invalidate((Object)this.tenantContext.tenantId());
    }

    public void resetArtifactsCounter() {
        this.artifactsCounters.invalidate((Object)this.tenantContext.tenantId());
    }

    public void resetArtifactVersionsCounter(String groupId, String artifactId) {
        ArtifactVersionKey avk = new ArtifactVersionKey();
        avk.tenantId = this.tenantContext.tenantId();
        avk.groupId = groupId;
        avk.artifactId = artifactId;
        this.artifactVersionsCounters.invalidate((Object)avk);
    }

    private static class ArtifactVersionKey {
        String tenantId;
        String groupId;
        String artifactId;

        private ArtifactVersionKey() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArtifactVersionKey)) {
                return false;
            }
            ArtifactVersionKey other = (ArtifactVersionKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tenantId = this.tenantId;
            String other$tenantId = other.tenantId;
            if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                return false;
            }
            String this$groupId = this.groupId;
            String other$groupId = other.groupId;
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.artifactId;
            String other$artifactId = other.artifactId;
            return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ArtifactVersionKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tenantId = this.tenantId;
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            String $groupId = this.groupId;
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.artifactId;
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            return result;
        }
    }
}

