/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui.servlets;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.ui.URLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class RedirectFilter
implements Filter {
    @ConfigProperty(name="registry.enable-redirects")
    @Info(category="redirects", description="Enable redirects", availableSince="2.1.2.Final")
    Boolean redirectsEnabled;
    @ConfigProperty(name="registry.redirects")
    @Info(category="redirects", description="Registry redirects", availableSince="2.1.2.Final")
    Map<String, String> redirectsConfig;
    Map<String, String> redirects = new HashMap<String, String>();
    @Inject
    URLUtil urlUtil;

    @PostConstruct
    void init() {
        if (this.redirectsEnabled != null && this.redirectsEnabled.booleanValue()) {
            this.redirectsConfig.values().forEach(value -> {
                String[] split = value.split(",");
                if (split != null && split.length == 2) {
                    String key = split[0];
                    String val = split[1];
                    this.redirects.put(key, val);
                }
            });
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.redirectsEnabled != null && this.redirectsEnabled.booleanValue()) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String servletPath = request.getServletPath();
            if (servletPath == null || "".equals(servletPath)) {
                servletPath = "/";
            }
            if (this.redirects.containsKey(servletPath)) {
                response.sendRedirect(this.urlUtil.getExternalAbsoluteURL(request, this.redirects.get(servletPath)).toString());
                return;
            }
        }
        chain.doFilter(req, res);
    }

    public void destroy() {
    }
}

