/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.util;

import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.util.DataImporter;
import io.apicurio.registry.utils.impexp.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.CommentEntity;
import io.apicurio.registry.utils.impexp.ContentEntity;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.GroupEntity;
import io.apicurio.registry.utils.impexp.ManifestEntity;
import javax.transaction.Transactional;
import org.slf4j.Logger;

public abstract class AbstractDataImporter
implements DataImporter {
    private final Logger log;

    public AbstractDataImporter(Logger log) {
        this.log = log;
    }

    @Override
    @Transactional
    public void importEntity(Entity entity) throws RegistryStorageException {
        switch (entity.getEntityType()) {
            case ArtifactRule: {
                this.importArtifactRule((ArtifactRuleEntity)entity);
                break;
            }
            case ArtifactVersion: {
                this.importArtifactVersion((ArtifactVersionEntity)entity);
                break;
            }
            case Content: {
                this.importContent((ContentEntity)entity);
                break;
            }
            case GlobalRule: {
                this.importGlobalRule((GlobalRuleEntity)entity);
                break;
            }
            case Group: {
                this.importGroup((GroupEntity)entity);
                break;
            }
            case Comment: {
                this.importComment((CommentEntity)entity);
                break;
            }
            case Manifest: {
                ManifestEntity manifest = (ManifestEntity)entity;
                this.log.info("---------- Import Info ----------");
                this.log.info("System Name:    {}", (Object)manifest.systemName);
                this.log.info("System Desc:    {}", (Object)manifest.systemDescription);
                this.log.info("System Version: {}", (Object)manifest.systemVersion);
                this.log.info("Data exported on {} by user {}", (Object)manifest.exportedOn, (Object)manifest.exportedBy);
                this.log.info("---------- ----------- ----------");
                break;
            }
            default: {
                throw new RegistryStorageException("Unhandled entity type during import: " + entity.getEntityType());
            }
        }
    }

    public Logger getLog() {
        return this.log;
    }
}

