/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.List;
import java.util.Map;
import org.openapitools.openapidiff.core.compare.MapKeyDiff;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedPath;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.deferred.DeferredBuilder;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;

public class PathDiff {
    private final OpenApiDiff openApiDiff;

    public PathDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    public DeferredChanged<ChangedPath> diff(PathItem left, PathItem right, DiffContext context) {
        Map oldOperationMap = left.readOperationsMap();
        Map newOperationMap = right.readOperationsMap();
        MapKeyDiff operationsDiff = MapKeyDiff.diff(oldOperationMap, newOperationMap);
        List sharedMethods = operationsDiff.getSharedKey();
        DeferredBuilder builder = new DeferredBuilder();
        ChangedPath changedPath = new ChangedPath(context.getUrl(), left, right, context).setIncreased(operationsDiff.getIncreased()).setMissing(operationsDiff.getMissing());
        for (PathItem.HttpMethod method : sharedMethods) {
            Operation oldOperation = (Operation)oldOperationMap.get(method);
            Operation newOperation = (Operation)newOperationMap.get(method);
            builder.with(this.openApiDiff.getOperationDiff().diff(oldOperation, newOperation, context.copyWithMethod(method))).ifPresent(changedPath.getChanged()::add);
        }
        builder.with(this.openApiDiff.getExtensionsDiff().diff(left.getExtensions(), right.getExtensions(), context)).ifPresent(changedPath::setExtensions);
        return builder.buildIsChanged(changedPath);
    }
}

