/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedSecurityScheme;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedSecurityRequirement
implements ComposedChanged {
    private SecurityRequirement oldSecurityRequirement;
    private SecurityRequirement newSecurityRequirement;
    private SecurityRequirement missing;
    private SecurityRequirement increased;
    private List<ChangedSecurityScheme> changed;

    public ChangedSecurityRequirement(SecurityRequirement oldSecurityRequirement, SecurityRequirement newSecurityRequirement) {
        this.oldSecurityRequirement = oldSecurityRequirement;
        this.newSecurityRequirement = newSecurityRequirement;
        this.changed = new ArrayList<ChangedSecurityScheme>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return new ArrayList<Changed>(this.changed);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.increased == null && this.missing == null) {
            return DiffResult.NO_CHANGES;
        }
        if (this.increased == null) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public void addMissing(String key, List<String> scopes) {
        if (this.missing == null) {
            this.missing = new SecurityRequirement();
        }
        this.missing.put((Object)key, scopes);
    }

    public void addIncreased(String key, List<String> scopes) {
        if (this.increased == null) {
            this.increased = new SecurityRequirement();
        }
        this.increased.put((Object)key, scopes);
    }

    public void addChanged(ChangedSecurityScheme changedSecurityScheme) {
        this.changed.add(changedSecurityScheme);
    }

    public SecurityRequirement getOldSecurityRequirement() {
        return this.oldSecurityRequirement;
    }

    public SecurityRequirement getNewSecurityRequirement() {
        return this.newSecurityRequirement;
    }

    public SecurityRequirement getMissing() {
        return this.missing;
    }

    public SecurityRequirement getIncreased() {
        return this.increased;
    }

    public List<ChangedSecurityScheme> getChanged() {
        return this.changed;
    }

    public ChangedSecurityRequirement setOldSecurityRequirement(SecurityRequirement oldSecurityRequirement) {
        this.oldSecurityRequirement = oldSecurityRequirement;
        return this;
    }

    public ChangedSecurityRequirement setNewSecurityRequirement(SecurityRequirement newSecurityRequirement) {
        this.newSecurityRequirement = newSecurityRequirement;
        return this;
    }

    public ChangedSecurityRequirement setMissing(SecurityRequirement missing) {
        this.missing = missing;
        return this;
    }

    public ChangedSecurityRequirement setIncreased(SecurityRequirement increased) {
        this.increased = increased;
        return this;
    }

    public ChangedSecurityRequirement setChanged(List<ChangedSecurityScheme> changed) {
        this.changed = changed;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedSecurityRequirement that = (ChangedSecurityRequirement)o;
        return Objects.equals(this.oldSecurityRequirement, that.oldSecurityRequirement) && Objects.equals(this.newSecurityRequirement, that.newSecurityRequirement) && Objects.equals(this.missing, that.missing) && Objects.equals(this.increased, that.increased) && Objects.equals(this.changed, that.changed);
    }

    public int hashCode() {
        return Objects.hash(this.oldSecurityRequirement, this.newSecurityRequirement, this.missing, this.increased, this.changed);
    }

    public String toString() {
        return "ChangedSecurityRequirement(oldSecurityRequirement=" + this.getOldSecurityRequirement() + ", newSecurityRequirement=" + this.getNewSecurityRequirement() + ", missing=" + this.getMissing() + ", increased=" + this.getIncreased() + ", changed=" + this.getChanged() + ")";
    }
}

