/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.deferred;

import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import org.openapitools.openapidiff.core.compare.CacheKey;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;
import org.openapitools.openapidiff.core.model.deferred.DeferredLogger;
import org.openapitools.openapidiff.core.model.deferred.PendingChanged;
import org.openapitools.openapidiff.core.model.deferred.RecursiveSchemaSet;
import org.openapitools.openapidiff.core.model.deferred.SchemaDiffOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredSchemaCache {
    private static final Logger log = LoggerFactory.getLogger(DeferredSchemaCache.class);
    private final Map<CacheKey, SchemaDiffOperation> cache = new LinkedHashMap<CacheKey, SchemaDiffOperation>();
    private final Queue<CacheKey> processingQueue = new ArrayDeque<CacheKey>();
    private final OpenApiDiff openApiDiff;

    public DeferredSchemaCache(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    public SchemaDiffOperation addSchema(RecursiveSchemaSet refSet, CacheKey key, Schema left, Schema right) {
        if (!this.cache.containsKey(key)) {
            log.debug("Added schema cache {}", (Object)key);
            SchemaDiffOperation operation = new SchemaDiffOperation(this.openApiDiff, refSet, key, left, right);
            this.cache.put(key, operation);
            this.processingQueue.add(key);
            return operation;
        }
        return this.cache.get(key);
    }

    public DeferredChanged<ChangedSchema> getOrAddSchema(RecursiveSchemaSet refSet, CacheKey key, Schema left, Schema right) {
        SchemaDiffOperation operation;
        if (refSet.contains(key)) {
            log.debug("getOrAddSchema recursive call aborted {} ", (Object)key);
            return DeferredChanged.empty();
        }
        refSet.put(key);
        if (this.cache.containsKey(key)) {
            operation = this.cache.get(key);
            log.debug("getOrAddSchema cached {} {}", (Object)key, operation.diffResult);
        } else {
            operation = this.addSchema(refSet, key, left, right);
            log.debug("getOrAddSchema added {} {}", (Object)key, operation.diffResult);
        }
        return operation.diffResult;
    }

    public void process() {
        this.processSchemaQueue();
    }

    public void processSchemaQueue() {
        PendingChanged.logResolved();
        while (!this.processingQueue.isEmpty()) {
            CacheKey key = this.processingQueue.poll();
            if (key != null) {
                log.debug("Processing schema {}", (Object)key);
                SchemaDiffOperation operation = this.cache.get(key);
                DeferredChanged<ChangedSchema> realValue = operation.openApiDiff.getSchemaDiff().computeDiffForReal(operation.refSet, operation.left, operation.right, key.getContext());
                operation.processed = true;
                realValue.whenSet(value -> {
                    log.debug("Schema processed {} {}", (Object)key, DeferredLogger.logValue(value));
                    operation.diffResult.setValue((Optional<ChangedSchema>)value);
                });
                log.debug("Processing schema started {}", (Object)key);
            }
            PendingChanged.logResolved();
        }
    }

    public Collection<SchemaDiffOperation> getOperations() {
        return this.cache.values();
    }

    public List<ChangedSchema> getChangedSchemas() {
        return this.cache.values().stream().filter(op -> op.processed && op.diffResult.isPresent()).map(op -> op.diffResult.get()).collect(Collectors.toList());
    }
}

