/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.output;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.LiTag;
import j2html.tags.specialized.LinkTag;
import j2html.tags.specialized.OlTag;
import j2html.tags.specialized.UlTag;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedApiResponse;
import org.openapitools.openapidiff.core.model.ChangedContent;
import org.openapitools.openapidiff.core.model.ChangedMediaType;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;
import org.openapitools.openapidiff.core.model.ChangedOperation;
import org.openapitools.openapidiff.core.model.ChangedParameter;
import org.openapitools.openapidiff.core.model.ChangedParameters;
import org.openapitools.openapidiff.core.model.ChangedResponse;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;
import org.openapitools.openapidiff.core.model.Endpoint;
import org.openapitools.openapidiff.core.output.Render;
import org.openapitools.openapidiff.core.utils.RefPointer;
import org.openapitools.openapidiff.core.utils.RefType;

public class HtmlRender
implements Render {
    private static final RefPointer<Schema<?>> refPointer = new RefPointer(RefType.SCHEMAS);
    public static final String COMMENT = "comment";
    public static final String MISSING = "missing";
    private final String title;
    private final String linkCss;
    protected ChangedOpenApi diff;

    public HtmlRender() {
        this("Api Change Log", "http://deepoove.com/swagger-diff/stylesheets/demo.css");
    }

    public HtmlRender(String title, String linkCss) {
        this.title = title;
        this.linkCss = linkCss;
    }

    @Override
    public String render(ChangedOpenApi diff) {
        this.diff = diff;
        List<Endpoint> newEndpoints = diff.getNewEndpoints();
        OlTag ol_newEndpoint = this.ol_newEndpoint(newEndpoints);
        List<Endpoint> missingEndpoints = diff.getMissingEndpoints();
        OlTag ol_missingEndpoint = this.ol_missingEndpoint(missingEndpoints);
        List<Endpoint> deprecatedEndpoints = diff.getDeprecatedEndpoints();
        OlTag ol_deprecatedEndpoint = this.ol_deprecatedEndpoint(deprecatedEndpoints);
        List<ChangedOperation> changedOperations = diff.getChangedOperations();
        OlTag ol_changed = this.ol_changed(changedOperations);
        return this.renderHtml(ol_newEndpoint, ol_missingEndpoint, ol_deprecatedEndpoint, ol_changed);
    }

    public String renderHtml(OlTag ol_new, OlTag ol_miss, OlTag ol_deprec, OlTag ol_changed) {
        HtmlTag html = (HtmlTag)((HtmlTag)TagCreator.html().attr("lang", (Object)"en")).with(new DomContent[]{TagCreator.head().with(new DomContent[]{TagCreator.meta().withCharset("utf-8"), TagCreator.title((String)this.title), ((LinkTag)TagCreator.link().withRel("stylesheet")).withHref(this.linkCss)}), TagCreator.body().with(new DomContent[]{TagCreator.header().with((DomContent)TagCreator.h1((String)this.title)), ((DivTag)TagCreator.div().withClass("article")).with(new DomContent[]{TagCreator.div().with(new DomContent[]{TagCreator.h2((String)"What's New"), TagCreator.hr(), ol_new}), TagCreator.div().with(new DomContent[]{TagCreator.h2((String)"What's Deleted"), TagCreator.hr(), ol_miss}), TagCreator.div().with(new DomContent[]{TagCreator.h2((String)"What's Deprecated"), TagCreator.hr(), ol_deprec}), TagCreator.div().with(new DomContent[]{TagCreator.h2((String)"What's Changed"), TagCreator.hr(), ol_changed})})})});
        return TagCreator.document().render() + html.render();
    }

    private OlTag ol_newEndpoint(List<Endpoint> endpoints) {
        if (null == endpoints) {
            return TagCreator.ol();
        }
        OlTag ol = TagCreator.ol();
        for (Endpoint endpoint : endpoints) {
            ol.with((DomContent)this.li_newEndpoint(endpoint.getMethod().toString(), endpoint.getPathUrl(), endpoint.getSummary()));
        }
        return ol;
    }

    private LiTag li_newEndpoint(String method, String path, String desc) {
        return (LiTag)((LiTag)((LiTag)TagCreator.li().with((DomContent)TagCreator.span((String)method).withClass(method))).withText(path + " ")).with((DomContent)TagCreator.span((String)desc));
    }

    private OlTag ol_missingEndpoint(List<Endpoint> endpoints) {
        if (null == endpoints) {
            return TagCreator.ol();
        }
        OlTag ol = TagCreator.ol();
        for (Endpoint endpoint : endpoints) {
            ol.with((DomContent)this.li_missingEndpoint(endpoint.getMethod().toString(), endpoint.getPathUrl(), endpoint.getSummary()));
        }
        return ol;
    }

    private LiTag li_missingEndpoint(String method, String path, String desc) {
        return (LiTag)((LiTag)TagCreator.li().with(new DomContent[]{TagCreator.span((String)method).withClass(method), TagCreator.del().withText(path)})).with((DomContent)TagCreator.span((String)(" " + desc)));
    }

    private OlTag ol_deprecatedEndpoint(List<Endpoint> endpoints) {
        if (null == endpoints) {
            return TagCreator.ol();
        }
        OlTag ol = TagCreator.ol();
        for (Endpoint endpoint : endpoints) {
            ol.with((DomContent)this.li_deprecatedEndpoint(endpoint.getMethod().toString(), endpoint.getPathUrl(), endpoint.getSummary()));
        }
        return ol;
    }

    private LiTag li_deprecatedEndpoint(String method, String path, String desc) {
        return (LiTag)((LiTag)TagCreator.li().with(new DomContent[]{TagCreator.span((String)method).withClass(method), TagCreator.del().withText(path)})).with((DomContent)TagCreator.span((String)(" " + desc)));
    }

    private OlTag ol_changed(List<ChangedOperation> changedOperations) {
        if (null == changedOperations) {
            return TagCreator.ol();
        }
        OlTag ol = TagCreator.ol();
        for (ChangedOperation changedOperation : changedOperations) {
            String pathUrl = changedOperation.getPathUrl();
            String method = changedOperation.getHttpMethod().toString();
            String desc = Optional.ofNullable(changedOperation.getSummary()).map(ChangedMetadata::getRight).orElse("");
            UlTag ul_detail = (UlTag)TagCreator.ul().withClass("detail");
            if (Changed.result(changedOperation.getParameters()).isDifferent()) {
                ul_detail.with((DomContent)((LiTag)TagCreator.li().with((DomContent)TagCreator.h3((String)"Parameters"))).with((DomContent)this.ul_param(changedOperation.getParameters())));
            }
            if (changedOperation.resultRequestBody().isDifferent()) {
                ul_detail.with((DomContent)((LiTag)TagCreator.li().with((DomContent)TagCreator.h3((String)"Request"))).with((DomContent)this.ul_request(changedOperation.getRequestBody().getContent())));
            }
            if (changedOperation.resultApiResponses().isDifferent()) {
                ul_detail.with((DomContent)((LiTag)TagCreator.li().with((DomContent)TagCreator.h3((String)"Response"))).with((DomContent)this.ul_response(changedOperation.getApiResponses())));
            }
            ol.with((DomContent)((LiTag)((LiTag)((LiTag)TagCreator.li().with((DomContent)TagCreator.span((String)method).withClass(method))).withText(pathUrl + " ")).with((DomContent)TagCreator.span((String)desc))).with((DomContent)ul_detail));
        }
        return ol;
    }

    private UlTag ul_response(ChangedApiResponse changedApiResponse) {
        Map<String, ApiResponse> addResponses = changedApiResponse.getIncreased();
        Map<String, ApiResponse> delResponses = changedApiResponse.getMissing();
        Map<String, ChangedResponse> changedResponses = changedApiResponse.getChanged();
        UlTag ul = (UlTag)TagCreator.ul().withClass("change response");
        for (Map.Entry<String, ApiResponse> entry : addResponses.entrySet()) {
            ul.with((DomContent)this.li_addResponse(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, ApiResponse> entry : delResponses.entrySet()) {
            ul.with((DomContent)this.li_missingResponse(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : changedResponses.entrySet()) {
            ul.with((DomContent)this.li_changedResponse(entry.getKey(), (ChangedResponse)entry.getValue()));
        }
        return ul;
    }

    private LiTag li_addResponse(String name, ApiResponse response) {
        return (LiTag)((LiTag)TagCreator.li().withText(String.format("New response : [%s]", name))).with((DomContent)TagCreator.span((String)(null == response.getDescription() ? "" : "//" + response.getDescription())).withClass(COMMENT));
    }

    private LiTag li_missingResponse(String name, ApiResponse response) {
        return (LiTag)((LiTag)TagCreator.li().withText(String.format("Deleted response : [%s]", name))).with((DomContent)TagCreator.span((String)(null == response.getDescription() ? "" : "//" + response.getDescription())).withClass(COMMENT));
    }

    private LiTag li_changedResponse(String name, ChangedResponse response) {
        return (LiTag)((LiTag)((LiTag)TagCreator.li().withText(String.format("Changed response : [%s]", name))).with((DomContent)TagCreator.span((String)(null == response.getNewApiResponse() || null == response.getNewApiResponse().getDescription() ? "" : "//" + response.getNewApiResponse().getDescription())).withClass(COMMENT))).with((DomContent)this.ul_request(response.getContent()));
    }

    private UlTag ul_request(ChangedContent changedContent) {
        UlTag ul = (UlTag)TagCreator.ul().withClass("change request-body");
        if (changedContent != null) {
            for (String propName : changedContent.getIncreased().keySet()) {
                ul.with((DomContent)this.li_addRequest(propName, changedContent.getIncreased().get(propName)));
            }
            for (String propName : changedContent.getMissing().keySet()) {
                ul.with((DomContent)this.li_missingRequest(propName, changedContent.getMissing().get(propName)));
            }
            for (String propName : changedContent.getChanged().keySet()) {
                ul.with((DomContent)this.li_changedRequest(propName, changedContent.getChanged().get(propName)));
            }
        }
        return ul;
    }

    private LiTag li_addRequest(String name, MediaType request) {
        return (LiTag)TagCreator.li().withText(String.format("New body: '%s'", name));
    }

    private LiTag li_missingRequest(String name, MediaType request) {
        return (LiTag)TagCreator.li().withText(String.format("Deleted body: '%s'", name));
    }

    private LiTag li_changedRequest(String name, ChangedMediaType request) {
        LiTag li = (LiTag)((LiTag)TagCreator.li().with((DomContent)this.div_changedSchema(request.getSchema()))).withText(String.format("Changed body: '%s'", name));
        if (request.isIncompatible()) {
            this.incompatibilities(li, request.getSchema());
        }
        return li;
    }

    private DivTag div_changedSchema(ChangedSchema schema) {
        DivTag div = TagCreator.div();
        div.with((DomContent)TagCreator.h3((String)("Schema" + (schema.isIncompatible() ? " incompatible" : ""))));
        return div;
    }

    private void incompatibilities(LiTag output, ChangedSchema schema) {
        this.incompatibilities((ContainerTag<?>)output, "", schema);
    }

    private void incompatibilities(ContainerTag<?> output, String propName, ChangedSchema schema) {
        if (schema.getItems() != null) {
            this.items(output, propName, schema.getItems());
        }
        if (schema.isCoreChanged() == DiffResult.INCOMPATIBLE && schema.isChangedType()) {
            String type = this.type(schema.getOldSchema()) + " -> " + this.type(schema.getNewSchema());
            this.property(output, propName, "Changed property type", type);
        }
        String prefix = propName.isEmpty() ? "" : propName + ".";
        this.properties(output, prefix, "Missing property", schema.getMissingProperties(), schema.getContext());
        schema.getChangedProperties().forEach((name, property) -> this.incompatibilities(output, prefix + name, (ChangedSchema)property));
    }

    private void items(ContainerTag<?> output, String propName, ChangedSchema schema) {
        this.incompatibilities(output, propName + "[n]", schema);
    }

    private void properties(ContainerTag<?> output, String propPrefix, String title, Map<String, Schema<?>> properties, DiffContext context) {
        if (properties != null) {
            properties.forEach((key, value) -> this.resolveProperty(output, propPrefix, (String)key, (Schema<?>)value, title));
        }
    }

    private void resolveProperty(ContainerTag<?> output, String propPrefix, String key, Schema<?> value, String title) {
        try {
            this.property(output, propPrefix + key, title, this.resolve(value));
        }
        catch (Exception e) {
            this.property(output, propPrefix + key, title, this.type(value));
        }
    }

    protected void property(ContainerTag<?> output, String name, String title, Schema<?> schema) {
        this.property(output, name, title, this.type(schema));
    }

    protected void property(ContainerTag<?> output, String name, String title, String type) {
        output.with((DomContent)TagCreator.p((String)String.format("%s: %s (%s)", title, name, type)).withClass(MISSING));
    }

    protected Schema<?> resolve(Schema<?> schema) {
        return refPointer.resolveRef(this.diff.getNewSpecOpenApi().getComponents(), schema, schema.get$ref());
    }

    protected String type(Schema<?> schema) {
        String result = "object";
        if (schema == null) {
            result = "no schema";
        } else if (schema instanceof ArraySchema) {
            result = "array";
        } else if (schema.getType() != null) {
            result = schema.getType();
        }
        return result;
    }

    private UlTag ul_param(ChangedParameters changedParameters) {
        List<Parameter> addParameters = changedParameters.getIncreased();
        List<Parameter> delParameters = changedParameters.getMissing();
        List<ChangedParameter> changed = changedParameters.getChanged();
        UlTag ul = (UlTag)TagCreator.ul().withClass("change param");
        for (Parameter parameter : addParameters) {
            ul.with((DomContent)this.li_addParam(parameter));
        }
        for (ChangedParameter changedParameter : changed) {
            ul.with((DomContent)this.li_changedParam(changedParameter));
        }
        for (Parameter parameter : delParameters) {
            ul.with((DomContent)this.li_missingParam(parameter));
        }
        return ul;
    }

    private LiTag li_addParam(Parameter param) {
        return (LiTag)((LiTag)TagCreator.li().withText("Add " + param.getName() + " in " + param.getIn())).with((DomContent)TagCreator.span((String)(null == param.getDescription() ? "" : "//" + param.getDescription())).withClass(COMMENT));
    }

    private LiTag li_missingParam(Parameter param) {
        return (LiTag)((LiTag)((LiTag)((LiTag)((LiTag)TagCreator.li().withClass(MISSING)).with((DomContent)TagCreator.span((String)"Delete"))).with((DomContent)TagCreator.del((String)param.getName()))).with((DomContent)TagCreator.span((String)"in ").withText(param.getIn()))).with((DomContent)TagCreator.span((String)(null == param.getDescription() ? "" : "//" + param.getDescription())).withClass(COMMENT));
    }

    private LiTag li_deprecatedParam(ChangedParameter param) {
        return (LiTag)((LiTag)((LiTag)((LiTag)((LiTag)TagCreator.li().withClass(MISSING)).with((DomContent)TagCreator.span((String)"Deprecated"))).with((DomContent)TagCreator.del((String)param.getName()))).with((DomContent)TagCreator.span((String)"in ").withText(param.getIn()))).with((DomContent)TagCreator.span((String)(null == param.getNewParameter().getDescription() ? "" : "//" + param.getNewParameter().getDescription())).withClass(COMMENT));
    }

    private LiTag li_changedParam(ChangedParameter changeParam) {
        if (changeParam.isDeprecated()) {
            return this.li_deprecatedParam(changeParam);
        }
        boolean changeRequired = changeParam.isChangeRequired();
        boolean changeDescription = Optional.ofNullable(changeParam.getDescription()).map(Changed::isDifferent).orElse(false);
        Parameter rightParam = changeParam.getNewParameter();
        Parameter leftParam = changeParam.getNewParameter();
        LiTag li = (LiTag)TagCreator.li().withText(changeParam.getName() + " in " + changeParam.getIn());
        if (changeRequired) {
            li.withText(" change into " + (rightParam.getRequired() != false ? "required" : "not required"));
        }
        if (changeDescription) {
            ((LiTag)((LiTag)((LiTag)li.withText(" Notes ")).with((DomContent)TagCreator.del((String)leftParam.getDescription()).withClass(COMMENT))).withText(" change into ")).with((DomContent)TagCreator.span((String)rightParam.getDescription()).withClass(COMMENT));
        }
        return li;
    }
}

