/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.types.provider;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.canon.AsyncApiContentCanonicalizer;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.content.dereference.AsyncApiDereferencer;
import io.apicurio.registry.content.dereference.ContentDereferencer;
import io.apicurio.registry.content.extract.AsyncApiContentExtractor;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.content.refs.AsyncApiReferenceFinder;
import io.apicurio.registry.content.refs.ReferenceFinder;
import io.apicurio.registry.content.util.ContentTypeUtil;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.NoopCompatibilityChecker;
import io.apicurio.registry.rules.validity.AsyncApiContentValidator;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.types.provider.AbstractArtifactTypeUtilProvider;
import java.util.Map;

public class AsyncApiArtifactTypeUtilProvider
extends AbstractArtifactTypeUtilProvider {
    @Override
    public boolean acceptsContent(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        try {
            String contentType = content.getContentType();
            JsonNode tree = null;
            tree = contentType.toLowerCase().contains("yml") || contentType.toLowerCase().contains("yaml") ? ContentTypeUtil.parseYaml((ContentHandle)content.getContent()) : ContentTypeUtil.parseJson((ContentHandle)content.getContent());
            if (tree.has("asyncapi")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getArtifactType() {
        return "ASYNCAPI";
    }

    @Override
    protected CompatibilityChecker createCompatibilityChecker() {
        return NoopCompatibilityChecker.INSTANCE;
    }

    @Override
    protected ContentCanonicalizer createContentCanonicalizer() {
        return new AsyncApiContentCanonicalizer();
    }

    @Override
    protected ContentValidator createContentValidator() {
        return new AsyncApiContentValidator();
    }

    @Override
    protected ContentExtractor createContentExtractor() {
        return new AsyncApiContentExtractor();
    }

    @Override
    public ContentDereferencer getContentDereferencer() {
        return new AsyncApiDereferencer();
    }

    @Override
    public ReferenceFinder getReferenceFinder() {
        return new AsyncApiReferenceFinder();
    }

    @Override
    public boolean supportsReferencesWithContext() {
        return true;
    }
}

