/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.types.provider;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.content.canon.EnhancedAvroContentCanonicalizer;
import io.apicurio.registry.content.dereference.AvroDereferencer;
import io.apicurio.registry.content.dereference.ContentDereferencer;
import io.apicurio.registry.content.extract.AvroContentExtractor;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.content.refs.AvroReferenceFinder;
import io.apicurio.registry.content.refs.ReferenceFinder;
import io.apicurio.registry.content.util.ContentTypeUtil;
import io.apicurio.registry.rules.compatibility.AvroCompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.validity.AvroContentValidator;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.types.provider.AbstractArtifactTypeUtilProvider;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.avro.Schema;

public class AvroArtifactTypeUtilProvider
extends AbstractArtifactTypeUtilProvider {
    private static final Pattern QUOTED_BRACKETS = Pattern.compile(": *\"\\{}\"");

    private static String removeQuotedBrackets(String content) {
        return QUOTED_BRACKETS.matcher(content).replaceAll(":{}");
    }

    @Override
    public boolean acceptsContent(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        try {
            if (content.getContentType() != null && content.getContentType().toLowerCase().contains("json") && !ContentTypeUtil.isParsableJson((ContentHandle)content.getContent())) {
                return false;
            }
            Schema.Parser parser = new Schema.Parser();
            ArrayList<Schema> schemaRefs = new ArrayList<Schema>();
            for (Map.Entry<String, TypedContent> referencedContent : resolvedReferences.entrySet()) {
                if (parser.getTypes().containsKey(referencedContent.getKey())) continue;
                Schema schemaRef = parser.parse(referencedContent.getValue().getContent().content());
                schemaRefs.add(schemaRef);
            }
            Schema schema = parser.parse(AvroArtifactTypeUtilProvider.removeQuotedBrackets(content.getContent().content()));
            schema.toString(schemaRefs, false);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getArtifactType() {
        return "AVRO";
    }

    @Override
    protected CompatibilityChecker createCompatibilityChecker() {
        return new AvroCompatibilityChecker();
    }

    @Override
    protected ContentCanonicalizer createContentCanonicalizer() {
        return new EnhancedAvroContentCanonicalizer();
    }

    @Override
    protected ContentValidator createContentValidator() {
        return new AvroContentValidator();
    }

    @Override
    protected ContentExtractor createContentExtractor() {
        return new AvroContentExtractor();
    }

    @Override
    public ContentDereferencer getContentDereferencer() {
        return new AvroDereferencer();
    }

    @Override
    public ReferenceFinder getReferenceFinder() {
        return new AvroReferenceFinder();
    }

    @Override
    public boolean supportsReferencesWithContext() {
        return false;
    }
}

