/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.types.provider;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.content.canon.XmlContentCanonicalizer;
import io.apicurio.registry.content.dereference.ContentDereferencer;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.content.extract.WsdlOrXsdContentExtractor;
import io.apicurio.registry.content.refs.NoOpReferenceFinder;
import io.apicurio.registry.content.refs.ReferenceFinder;
import io.apicurio.registry.content.util.ContentTypeUtil;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.NoopCompatibilityChecker;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.XsdContentValidator;
import io.apicurio.registry.types.provider.AbstractArtifactTypeUtilProvider;
import io.apicurio.registry.util.DocumentBuilderAccessor;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XsdArtifactTypeUtilProvider
extends AbstractArtifactTypeUtilProvider {
    @Override
    public boolean acceptsContent(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        try {
            Document xmlDocument;
            Element root;
            String ns;
            String contentType = content.getContentType();
            if (contentType.toLowerCase().contains("xml") && ContentTypeUtil.isParsableXml((ContentHandle)content.getContent()) && (ns = (root = (xmlDocument = DocumentBuilderAccessor.getDocumentBuilder().parse(content.getContent().stream())).getDocumentElement()).getNamespaceURI()) != null && ns.equals("http://www.w3.org/2001/XMLSchema")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getArtifactType() {
        return "XSD";
    }

    @Override
    protected CompatibilityChecker createCompatibilityChecker() {
        return NoopCompatibilityChecker.INSTANCE;
    }

    @Override
    protected ContentCanonicalizer createContentCanonicalizer() {
        return new XmlContentCanonicalizer();
    }

    @Override
    protected ContentValidator createContentValidator() {
        return new XsdContentValidator();
    }

    @Override
    protected ContentExtractor createContentExtractor() {
        return new WsdlOrXsdContentExtractor();
    }

    @Override
    public ContentDereferencer getContentDereferencer() {
        return null;
    }

    @Override
    public ReferenceFinder getReferenceFinder() {
        return NoOpReferenceFinder.INSTANCE;
    }

    @Override
    public boolean supportsReferencesWithContext() {
        return false;
    }
}

