/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.locks;

import com.ibm.asyncutil.locks.AsyncEpoch;
import java.util.concurrent.atomic.AtomicInteger;

abstract class AbstractSimpleEpoch
extends AtomicInteger
implements AsyncEpoch.EpochToken {
    static final int TERMINATED = Integer.MIN_VALUE;
    static final int ENTRANT_MASK = Integer.MAX_VALUE;
    static final int MAX_COUNT = Integer.MAX_VALUE;

    AbstractSimpleEpoch() {
    }

    abstract void onCleared();

    void onExit(int state) {
    }

    boolean isSpecialTerminateState(int state) {
        return false;
    }

    boolean isSpecialEnterState(int state) {
        return false;
    }

    final Status internalEnter() {
        int state;
        do {
            if (this.isSpecialEnterState(state = this.get())) {
                return Status.SPECIAL;
            }
            if ((state & Integer.MIN_VALUE) != 0) {
                return Status.TERMINATED;
            }
            if (state != Integer.MAX_VALUE) continue;
            throw new IllegalStateException("maximum epoch entrants exceeded");
        } while (!this.compareAndSet(state, state + 1));
        return Status.NORMAL;
    }

    final Status internalTerminate() {
        int newState;
        int state;
        do {
            if (this.isSpecialTerminateState(state = this.get())) {
                return Status.SPECIAL;
            }
            if ((state & Integer.MIN_VALUE) == 0) continue;
            return Status.TERMINATED;
        } while (!this.compareAndSet(state, newState = state | Integer.MIN_VALUE));
        if (newState == Integer.MIN_VALUE) {
            this.onCleared();
        }
        return Status.NORMAL;
    }

    public final boolean isTerminated() {
        return (this.get() & Integer.MIN_VALUE) != 0;
    }

    final boolean isCleared() {
        return this.get() == Integer.MIN_VALUE;
    }

    @Override
    public final void close() {
        int newState;
        int state;
        do {
            if (((state = this.get()) & Integer.MAX_VALUE) != 0) continue;
            throw new IllegalStateException("excessively closed epoch");
        } while (!this.compareAndSet(state, newState = state - 1));
        this.onExit(newState);
        if (newState == Integer.MIN_VALUE) {
            this.onCleared();
        }
    }

    @Override
    public String toString() {
        int state = this.get();
        return "Epoch [isTerminated=" + ((state & Integer.MIN_VALUE) != 0) + ", entrants=" + (state & Integer.MAX_VALUE) + "]";
    }

    static enum Status {
        NORMAL,
        TERMINATED,
        SPECIAL;

    }
}

