/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.rest.ConflictException;
import io.apicurio.registry.rest.v3.AdminResourceImpl;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.StorageEvent;
import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.error.ReadOnlyStorageException;
import io.apicurio.registry.storage.importing.ImportExportConfigProperties;
import io.apicurio.registry.types.Current;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.ObservesAsync;
import jakarta.inject.Inject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;

@ApplicationScoped
public class ImportLifecycleBean {
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    ImportExportConfigProperties importExportProps;
    @Inject
    AdminResourceImpl v3Admin;

    void onStorageReady(@ObservesAsync StorageEvent ev) {
        if (StorageEventType.READY.equals((Object)ev.getType()) && this.importExportProps.registryImportUrlProp.isPresent()) {
            this.log.info("Import URL exists.");
            URL registryImportUrl = this.importExportProps.registryImportUrlProp.get();
            try (BufferedInputStream registryImportZip = new BufferedInputStream(registryImportUrl.openStream());){
                this.log.info("Importing {} on startup.", (Object)registryImportUrl);
                this.v3Admin.importData(null, null, null, registryImportZip);
                this.log.info("Registry successfully imported from {}", (Object)registryImportUrl);
            }
            catch (IOException ioe) {
                this.log.error("Registry import from {} failed", (Object)registryImportUrl, (Object)ioe);
            }
            catch (ReadOnlyStorageException rose) {
                this.log.error("Registry import failed, because the storage is in read-only mode.");
            }
            catch (ConflictException ce) {
                this.log.info("Import skipped, registry not empty.");
            }
            catch (Exception e) {
                this.log.error("Registry import failed", (Throwable)e);
            }
        }
    }
}

