/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.auth.IAccessController;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.error.NotFoundException;
import io.apicurio.registry.types.Current;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.inject.Inject;
import jakarta.interceptor.InvocationContext;

public abstract class AbstractAccessController
implements IAccessController {
    @Inject
    AuthConfig authConfig;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    @Current
    RegistryStorage storage;

    protected boolean isOwner(InvocationContext context) {
        Authorized annotation = context.getMethod().getAnnotation(Authorized.class);
        AuthorizedStyle style = annotation.style();
        if (style == AuthorizedStyle.GroupAndArtifact) {
            String groupId = this.getStringParam(context, 0);
            String artifactId = this.getStringParam(context, 1);
            return this.verifyArtifactOwner(groupId, artifactId);
        }
        if (style == AuthorizedStyle.GroupOnly && this.authConfig.ownerOnlyAuthorizationLimitGroupAccess.get().booleanValue()) {
            String groupId = this.getStringParam(context, 0);
            return this.verifyGroupOwner(groupId);
        }
        if (style == AuthorizedStyle.ArtifactOnly) {
            String artifactId = this.getStringParam(context, 0);
            return this.verifyArtifactOwner(null, artifactId);
        }
        if (style == AuthorizedStyle.GlobalId) {
            long globalId = this.getLongParam(context, 0);
            return this.verifyArtifactOwner(globalId);
        }
        return true;
    }

    private boolean verifyGroupOwner(String groupId) {
        try {
            GroupMetaDataDto dto = this.storage.getGroupMetaData(groupId);
            String owner = dto.getOwner();
            return owner == null || owner.equals(this.securityIdentity.getPrincipal().getName());
        }
        catch (NotFoundException nfe) {
            return true;
        }
    }

    private boolean verifyArtifactOwner(String groupId, String artifactId) {
        try {
            ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(groupId, artifactId);
            String owner = dto.getOwner();
            return owner == null || owner.equals(this.securityIdentity.getPrincipal().getName());
        }
        catch (NotFoundException nfe) {
            return true;
        }
    }

    private boolean verifyArtifactOwner(long globalId) {
        try {
            ArtifactVersionMetaDataDto versionMetaData = this.storage.getArtifactVersionMetaData(globalId);
            ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(versionMetaData.getGroupId(), versionMetaData.getArtifactId());
            String owner = dto.getOwner();
            return owner == null || owner.equals(this.securityIdentity.getPrincipal().getName());
        }
        catch (NotFoundException nfe) {
            return true;
        }
    }

    protected String getStringParam(InvocationContext context, int index) {
        return (String)context.getParameters()[index];
    }

    protected Long getLongParam(InvocationContext context, int index) {
        return (Long)context.getParameters()[index];
    }
}

