/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.registry.auth.AdminOverride;
import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.OwnerBasedAccessController;
import io.apicurio.registry.auth.RoleBasedAccessApiOperation;
import io.apicurio.registry.auth.RoleBasedAccessController;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.slf4j.Logger;

@Authorized
@Interceptor
@Priority(value=2000)
public class AuthorizedInterceptor {
    @Inject
    Logger log;
    @Inject
    AuthConfig authConfig;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    Instance<JsonWebToken> jsonWebToken;
    @Inject
    AdminOverride adminOverride;
    @Inject
    RoleBasedAccessController rbac;
    @Inject
    OwnerBasedAccessController obac;

    @AroundInvoke
    public Object authorizeMethod(InvocationContext context) throws Exception {
        RoleBasedAccessApiOperation rbacOpAnnotation = context.getMethod().getAnnotation(RoleBasedAccessApiOperation.class);
        if (rbacOpAnnotation != null && !this.authConfig.isApplicationRbacEnabled()) {
            this.log.warn("Access to /admin/roleMappings denied because application managed RBAC is not enabled.");
            throw new ForbiddenException("Application RBAC not enabled.");
        }
        if (!this.authConfig.oidcAuthEnabled && !this.authConfig.basicAuthEnabled) {
            return context.proceed();
        }
        this.log.trace("Authentication enabled, protected resource: " + context.getMethod());
        Authorized annotation = context.getMethod().getAnnotation(Authorized.class);
        try {
            if (this.securityIdentity == null || this.securityIdentity.isAnonymous()) {
                this.log.debug("Identity was null or anonymous: " + this.securityIdentity);
                if (annotation.level() == AuthorizedLevel.None) {
                    this.log.trace("Anonymous user is being granted access to unprotected operation.");
                    return context.proceed();
                }
                if (this.authConfig.anonymousReadAccessEnabled.get().booleanValue() && annotation.level() == AuthorizedLevel.Read) {
                    this.log.trace("Anonymous user is being granted access to read-only operation.");
                    return context.proceed();
                }
                this.log.warn("Authentication credentials missing and required for protected endpoint.");
                throw new UnauthorizedException("User is not authenticated.");
            }
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Throwable t) {
            this.log.error("Error enforcing access.", t);
            throw t;
        }
        this.log.info("principalId:" + this.securityIdentity.getPrincipal().getName());
        this.log.info("roles:" + this.securityIdentity.getRoles());
        if (annotation.level() == AuthorizedLevel.None) {
            return context.proceed();
        }
        if (this.adminOverride.isAdmin()) {
            this.log.trace("Admin override successful.");
            return context.proceed();
        }
        if (this.authConfig.authenticatedReadAccessEnabled.get().booleanValue() && annotation.level() == AuthorizedLevel.Read) {
            return context.proceed();
        }
        if (this.authConfig.roleBasedAuthorizationEnabled && !this.rbac.isAuthorized(context)) {
            this.log.warn("RBAC enabled and required role missing.");
            throw new ForbiddenException("User " + this.securityIdentity.getPrincipal().getName() + " is not authorized to perform the requested operation.");
        }
        if (this.authConfig.ownerOnlyAuthorizationEnabled.get().booleanValue() && !this.obac.isAuthorized(context)) {
            this.log.warn("OBAC enabled and operation not permitted due to wrong owner.");
            throw new ForbiddenException("User " + this.securityIdentity.getPrincipal().getName() + " is not authorized to perform the requested operation.");
        }
        return context.proceed();
    }
}

