/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.auth.RoleProvider;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Context;
import java.util.Objects;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@RequestScoped
public class HeaderRoleProvider
implements RoleProvider {
    @ConfigProperty(name="apicurio.auth.role-source.header.name")
    @Info(category="auth", description="Header authorization name", availableSince="2.4.3.Final")
    String roleHeader;
    @Inject
    AuthConfig authConfig;
    @Inject
    @Context
    HttpServletRequest request;

    @Override
    public boolean isReadOnly() {
        return Objects.equals(this.request.getHeader(this.roleHeader), this.authConfig.readOnlyRole);
    }

    @Override
    public boolean isDeveloper() {
        return Objects.equals(this.request.getHeader(this.roleHeader), this.authConfig.developerRole);
    }

    @Override
    public boolean isAdmin() {
        return Objects.equals(this.request.getHeader(this.roleHeader), this.authConfig.adminRole);
    }
}

