/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v7.impl;

import io.apicurio.common.apps.util.Pair;
import io.apicurio.registry.ccompat.dto.SchemaReference;
import io.apicurio.registry.ccompat.rest.error.ConflictException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.ccompat.rest.v7.impl.ApiConverter;
import io.apicurio.registry.ccompat.rest.v7.impl.CCompatConfig;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.model.BranchId;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.model.GAV;
import io.apicurio.registry.rest.v3.beans.ArtifactReference;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.dto.SearchedArtifactDto;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.RuleNotFoundException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import io.apicurio.registry.storage.impl.sql.RegistryContentUtils;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.VersionState;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.AvroTypeException;
import org.apache.avro.SchemaParseException;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;

public abstract class AbstractResource {
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Inject
    ApiConverter converter;
    @Inject
    CCompatConfig cconfig;
    @Inject
    ArtifactTypeUtilProviderFactory factory;

    protected String toSubjectWithGroupConcat(String groupId, String artifactId) {
        return (groupId == null ? "" : groupId) + this.cconfig.groupConcatSeparator + artifactId;
    }

    protected String toSubjectWithGroupConcat(SearchedArtifactDto dto) {
        return this.toSubjectWithGroupConcat(dto.getGroupId(), dto.getArtifactId());
    }

    private Pair<String, String> toGAFromGroupConcatSubject(String subject) {
        int sepIdx = subject.indexOf(this.cconfig.groupConcatSeparator);
        if (sepIdx < 1) {
            throw new BadRequestException("Invalid subject format.  Should be:  groupId" + this.cconfig.groupConcatSeparator + "artifactId");
        }
        String groupId = subject.substring(0, sepIdx);
        String artifactId = subject.substring(sepIdx + this.cconfig.groupConcatSeparator.length());
        return new Pair((Object)groupId, (Object)artifactId);
    }

    protected GA getGA(String groupId, String artifactId) {
        String gid = groupId;
        String aid = artifactId;
        if (this.cconfig.groupConcatEnabled) {
            Pair<String, String> ga = this.toGAFromGroupConcatSubject(artifactId);
            gid = (String)ga.getLeft();
            aid = (String)ga.getRight();
        }
        return new GA(gid, aid);
    }

    protected ArtifactVersionMetaDataDto createOrUpdateArtifact(String artifactId, String schema, String artifactType, List<SchemaReference> references, String groupId) {
        ArtifactVersionMetaDataDto res;
        List<ArtifactReferenceDto> parsedReferences = this.parseReferences(references, groupId);
        List<ArtifactReference> artifactReferences = parsedReferences.stream().map(dto -> ((ArtifactReference.ArtifactReferenceBuilder)((ArtifactReference.ArtifactReferenceBuilder)((ArtifactReference.ArtifactReferenceBuilder)((ArtifactReference.ArtifactReferenceBuilder)ArtifactReference.builder().name(dto.getName())).groupId(dto.getGroupId())).artifactId(dto.getArtifactId())).version(dto.getVersion())).build()).collect(Collectors.toList());
        Map<String, TypedContent> resolvedReferences = RegistryContentUtils.recursivelyResolveReferences(parsedReferences, this.storage::getContentByReference);
        try {
            ContentHandle schemaContent = ContentHandle.create((String)schema);
            String contentType = "application/json";
            if (artifactType.equals("PROTOBUF")) {
                contentType = "application/x-protobuf";
            }
            if (!this.doesArtifactExist(artifactId, groupId)) {
                TypedContent typedSchemaContent = TypedContent.create((ContentHandle)schemaContent, (String)contentType);
                this.rulesService.applyRules(groupId, artifactId, artifactType, typedSchemaContent, RuleApplicationType.CREATE, artifactReferences, resolvedReferences);
                EditableArtifactMetaDataDto artifactMetaData = EditableArtifactMetaDataDto.builder().build();
                EditableVersionMetaDataDto firstVersionMetaData = EditableVersionMetaDataDto.builder().build();
                ContentWrapperDto firstVersionContent = ContentWrapperDto.builder().content(schemaContent).contentType(contentType).references(parsedReferences).build();
                res = (ArtifactVersionMetaDataDto)this.storage.createArtifact(groupId, artifactId, artifactType, artifactMetaData, null, firstVersionContent, firstVersionMetaData, null, false).getValue();
            } else {
                TypedContent typedSchemaContent = TypedContent.create((ContentHandle)schemaContent, (String)contentType);
                this.rulesService.applyRules(groupId, artifactId, artifactType, typedSchemaContent, RuleApplicationType.UPDATE, artifactReferences, resolvedReferences);
                ContentWrapperDto versionContent = ContentWrapperDto.builder().content(schemaContent).contentType(contentType).references(parsedReferences).build();
                res = this.storage.createArtifactVersion(groupId, artifactId, null, artifactType, versionContent, EditableVersionMetaDataDto.builder().build(), List.of(), false);
            }
        }
        catch (RuleViolationException ex) {
            if (ex.getRuleType() == RuleType.VALIDITY) {
                throw new UnprocessableEntityException(ex);
            }
            throw new ConflictException(ex);
        }
        return res;
    }

    protected ArtifactVersionMetaDataDto lookupSchema(String groupId, String artifactId, String schema, List<SchemaReference> schemaReferences, String schemaType, boolean normalize) {
        try {
            ArtifactVersionMetaDataDto amd;
            String type = schemaType == null ? "AVRO" : schemaType;
            String contentType = type.equals("PROTOBUF") ? "application/x-protobuf" : "application/json";
            TypedContent typedSchemaContent = TypedContent.create((ContentHandle)ContentHandle.create((String)schema), (String)contentType);
            List<ArtifactReferenceDto> artifactReferences = this.parseReferences(schemaReferences, groupId);
            ArtifactTypeUtilProvider artifactTypeProvider = this.factory.getArtifactTypeProvider(type);
            if (this.cconfig.canonicalHashModeEnabled.get().booleanValue() || normalize) {
                try {
                    amd = this.storage.getArtifactVersionMetaDataByContent(groupId, artifactId, true, typedSchemaContent, artifactReferences);
                }
                catch (ArtifactNotFoundException ex) {
                    if (type.equals("AVRO")) {
                        amd = this.storage.getArtifactVersions(groupId, artifactId).stream().filter(version -> {
                            StoredArtifactVersionDto artifactVersion = this.storage.getArtifactVersionContent(groupId, artifactId, (String)version);
                            TypedContent typedArtifactVersion = TypedContent.create((ContentHandle)artifactVersion.getContent(), (String)artifactVersion.getContentType());
                            Map<String, TypedContent> artifactVersionReferences = RegistryContentUtils.recursivelyResolveReferences(artifactVersion.getReferences(), this.storage::getContentByReference);
                            String dereferencedExistingContentSha = DigestUtils.sha256Hex((String)artifactTypeProvider.getContentDereferencer().dereference(typedArtifactVersion, artifactVersionReferences).getContent().content());
                            return dereferencedExistingContentSha.equals(DigestUtils.sha256Hex((String)schema));
                        }).findAny().map(version -> this.storage.getArtifactVersionMetaData(groupId, artifactId, (String)version)).orElseThrow(() -> ex);
                    }
                    throw ex;
                }
            } else {
                amd = this.storage.getArtifactVersionMetaDataByContent(groupId, artifactId, false, typedSchemaContent, artifactReferences);
            }
            return amd;
        }
        catch (AvroTypeException | SchemaParseException ex) {
            throw new UnprocessableEntityException(ex.getMessage());
        }
    }

    protected Map<String, TypedContent> resolveReferences(List<SchemaReference> references) {
        Map<String, TypedContent> resolvedReferences = Collections.emptyMap();
        if (references != null && !references.isEmpty()) {
            List<ArtifactReferenceDto> referencesAsDtos = references.stream().map(schemaReference -> {
                ArtifactReferenceDto artifactReferenceDto = new ArtifactReferenceDto();
                artifactReferenceDto.setArtifactId(schemaReference.getSubject());
                artifactReferenceDto.setVersion(String.valueOf(schemaReference.getVersion()));
                artifactReferenceDto.setName(schemaReference.getName());
                artifactReferenceDto.setGroupId(null);
                return artifactReferenceDto;
            }).collect(Collectors.toList());
            resolvedReferences = RegistryContentUtils.recursivelyResolveReferences(referencesAsDtos, this.storage::getContentByReference);
            if (references.size() > resolvedReferences.size()) {
                throw new UnprocessableEntityException("Unresolved reference");
            }
        }
        return resolvedReferences;
    }

    protected boolean isArtifactActive(String artifactId, String groupId) {
        long count = this.storage.countActiveArtifactVersions(groupId, artifactId);
        return count > 0L;
    }

    protected String getLatestArtifactVersionForSubject(String artifactId, String groupId) {
        try {
            GAV latestGAV = this.storage.getBranchTip(new GA(groupId, artifactId), BranchId.LATEST, RegistryStorage.RetrievalBehavior.SKIP_DISABLED_LATEST);
            return latestGAV.getRawVersionId();
        }
        catch (ArtifactNotFoundException ex) {
            throw new VersionNotFoundException(groupId, artifactId, "latest");
        }
    }

    protected boolean shouldFilterState(boolean deleted, VersionState state) {
        if (deleted) {
            return true;
        }
        return state.equals((Object)VersionState.ENABLED);
    }

    protected boolean areAllSchemasDisabled(List<Long> globalIds) {
        return globalIds.stream().anyMatch(globalId -> {
            VersionState state = this.storage.getArtifactVersionMetaData((Long)globalId).getState();
            return state.equals((Object)VersionState.DISABLED);
        });
    }

    protected boolean doesArtifactExist(String artifactId, String groupId) {
        return this.storage.isArtifactExists(groupId, artifactId);
    }

    protected boolean doesArtifactRuleExist(String artifactId, RuleType type, String groupId) {
        try {
            this.storage.getArtifactRule(groupId, artifactId, type);
            return true;
        }
        catch (ArtifactNotFoundException | RuleNotFoundException ignored) {
            return false;
        }
    }

    protected boolean doesGlobalRuleExist(RuleType type) {
        try {
            this.storage.getGlobalRule(type);
            return true;
        }
        catch (RuleNotFoundException ignored) {
            return false;
        }
    }

    protected List<ArtifactReferenceDto> parseReferences(List<SchemaReference> references, String groupId) {
        if (references != null) {
            return references.stream().map(schemaReference -> {
                this.storage.getArtifactVersionMetaData(groupId, schemaReference.getSubject(), String.valueOf(schemaReference.getVersion()));
                return new ArtifactReferenceDto(groupId, schemaReference.getSubject(), String.valueOf(schemaReference.getVersion()), schemaReference.getName());
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected boolean isCcompatManagedType(String artifactType) {
        return artifactType.equals("AVRO") || artifactType.equals("PROTOBUF") || artifactType.equals("JSON");
    }

    protected <T> T parseVersionString(String subject, String versionString, String groupId, Function<String, T> then) {
        String version;
        block6: {
            if ("latest".equals(versionString)) {
                version = this.getLatestArtifactVersionForSubject(subject, groupId);
            } else {
                try {
                    int numericVersion = Integer.parseInt(versionString);
                    if (numericVersion >= 0) {
                        version = versionString;
                        break block6;
                    }
                    if (numericVersion == -1) {
                        version = this.getLatestArtifactVersionForSubject(subject, groupId);
                        break block6;
                    }
                    throw new ArtifactNotFoundException("Illegal version format: " + versionString);
                }
                catch (NumberFormatException e) {
                    throw new VersionNotFoundException(groupId, subject, versionString);
                }
            }
        }
        return then.apply(version);
    }
}

