/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v7.impl;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.CompatibilityCheckResponse;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.ccompat.rest.v7.CompatibilityResource;
import io.apicurio.registry.ccompat.rest.v7.impl.AbstractResource;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.UnprocessableSchemaException;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import jakarta.interceptor.Interceptors;
import java.util.Collections;
import java.util.List;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class CompatibilityResourceImpl
extends AbstractResource
implements CompatibilityResource {
    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public CompatibilityCheckResponse testCompatibilityBySubjectName(String subject, SchemaContent request, Boolean verbose, String groupId) throws Exception {
        GA ga = this.getGA(groupId, subject);
        boolean fverbose = verbose == null ? Boolean.FALSE : verbose;
        try {
            List<String> versions = this.storage.getArtifactVersions(ga.getRawGroupIdWithNull(), ga.getRawArtifactId());
            for (String version : versions) {
                ArtifactVersionMetaDataDto artifactVersionMetaData = this.storage.getArtifactVersionMetaData(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), version);
                String contentType = "application/json";
                if (artifactVersionMetaData.getArtifactType().equals("PROTOBUF")) {
                    contentType = "application/x-protobuf";
                }
                TypedContent typedContent = TypedContent.create((ContentHandle)ContentHandle.create((String)request.getSchema()), (String)contentType);
                this.rulesService.applyRules(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), version, artifactVersionMetaData.getArtifactType(), typedContent, Collections.emptyList(), Collections.emptyMap());
            }
            return CompatibilityCheckResponse.IS_COMPATIBLE;
        }
        catch (RuleViolationException ex) {
            if (fverbose) {
                return new CompatibilityCheckResponse(false, ex.getMessage());
            }
            return CompatibilityCheckResponse.IS_NOT_COMPATIBLE;
        }
        catch (UnprocessableSchemaException ex) {
            throw new UnprocessableEntityException(ex.getMessage());
        }
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public CompatibilityCheckResponse testCompatibilityByVersion(String subject, String versionString, SchemaContent request, Boolean verbose, String groupId) throws Exception {
        boolean fverbose = verbose == null ? Boolean.FALSE : verbose;
        GA ga = this.getGA(groupId, subject);
        return this.parseVersionString(ga.getRawArtifactId(), versionString, ga.getRawGroupIdWithNull(), version -> {
            try {
                ArtifactVersionMetaDataDto artifact = this.storage.getArtifactVersionMetaData(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), (String)version);
                String contentType = "application/json";
                if (artifact.getArtifactType().equals("PROTOBUF")) {
                    contentType = "application/x-protobuf";
                }
                TypedContent typedContent = TypedContent.create((ContentHandle)ContentHandle.create((String)request.getSchema()), (String)contentType);
                this.rulesService.applyRules(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), (String)version, artifact.getArtifactType(), typedContent, Collections.emptyList(), Collections.emptyMap());
                return CompatibilityCheckResponse.IS_COMPATIBLE;
            }
            catch (RuleViolationException ex) {
                if (fverbose) {
                    return new CompatibilityCheckResponse(false, ex.getMessage());
                }
                return CompatibilityCheckResponse.IS_NOT_COMPATIBLE;
            }
            catch (UnprocessableSchemaException ex) {
                throw new UnprocessableEntityException(ex.getMessage());
            }
        });
    }
}

