/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v7.impl;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.logging.audit.Audited;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.CompatibilityLevelDto;
import io.apicurio.registry.ccompat.dto.CompatibilityLevelParamDto;
import io.apicurio.registry.ccompat.rest.v7.ConfigResource;
import io.apicurio.registry.ccompat.rest.v7.impl.AbstractResource;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.error.RuleNotFoundException;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.Functional;
import jakarta.interceptor.Interceptors;
import java.util.Optional;
import java.util.function.Supplier;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class ConfigResourceImpl
extends AbstractResource
implements ConfigResource {
    private CompatibilityLevelParamDto getCompatibilityLevel(Supplier<String> supplyLevel) {
        try {
            return new CompatibilityLevelParamDto(Optional.of(CompatibilityLevel.valueOf((String)supplyLevel.get())).get().name());
        }
        catch (RuleNotFoundException ex) {
            return new CompatibilityLevelParamDto(CompatibilityLevelDto.Level.NONE.name());
        }
    }

    private <X extends Exception> void updateCompatibilityLevel(CompatibilityLevelDto.Level level, Functional.Runnable1Ex<RuleConfigurationDto, X> updater, Functional.RunnableEx<X> deleter) throws X {
        if (level == CompatibilityLevelDto.Level.NONE) {
            deleter.run();
        } else {
            String levelString = level.getStringValue();
            try {
                CompatibilityLevel.valueOf((String)levelString);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Illegal compatibility level: " + levelString);
            }
            updater.run(RuleConfigurationDto.builder().configuration(levelString).build());
        }
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public CompatibilityLevelParamDto getGlobalCompatibilityLevel() {
        return this.getCompatibilityLevel(() -> this.storage.getGlobalRule(RuleType.COMPATIBILITY).getConfiguration());
    }

    @Override
    @Audited(extractParameters={"0", "rule"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public CompatibilityLevelDto updateGlobalCompatibilityLevel(CompatibilityLevelDto request) {
        this.updateCompatibilityLevel(request.getCompatibility(), dto -> {
            if (!this.doesGlobalRuleExist(RuleType.COMPATIBILITY)) {
                this.storage.createGlobalRule(RuleType.COMPATIBILITY, (RuleConfigurationDto)dto);
            } else {
                this.storage.updateGlobalRule(RuleType.COMPATIBILITY, (RuleConfigurationDto)dto);
            }
        }, () -> this.storage.deleteGlobalRule(RuleType.COMPATIBILITY));
        return request;
    }

    @Override
    @Audited(extractParameters={"0", "artifact_id", "1", "rule"})
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public CompatibilityLevelDto updateSubjectCompatibilityLevel(String subject, CompatibilityLevelDto request, String groupId) {
        GA ga = this.getGA(groupId, subject);
        this.updateCompatibilityLevel(request.getCompatibility(), dto -> {
            if (!this.doesArtifactRuleExist(ga.getRawArtifactId(), RuleType.COMPATIBILITY, ga.getRawGroupIdWithNull())) {
                this.storage.createArtifactRule(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), RuleType.COMPATIBILITY, (RuleConfigurationDto)dto);
            } else {
                this.storage.updateArtifactRule(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), RuleType.COMPATIBILITY, (RuleConfigurationDto)dto);
            }
        }, () -> {
            try {
                this.storage.deleteArtifactRule(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), RuleType.COMPATIBILITY);
            }
            catch (RuleNotFoundException ruleNotFoundException) {
                // empty catch block
            }
        });
        return request;
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public CompatibilityLevelParamDto getSubjectCompatibilityLevel(String subject, String groupId) {
        GA ga = this.getGA(groupId, subject);
        return this.getCompatibilityLevel(() -> this.storage.getArtifactRule(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), RuleType.COMPATIBILITY).getConfiguration());
    }

    @Override
    @Audited(extractParameters={"0", "artifact_id"})
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public CompatibilityLevelParamDto deleteSubjectCompatibility(String subject, String groupId) {
        GA ga = this.getGA(groupId, subject);
        CompatibilityLevelParamDto compatibilityLevel = this.getCompatibilityLevel(() -> this.storage.getArtifactRule(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), RuleType.COMPATIBILITY).getConfiguration());
        if (!CompatibilityLevel.NONE.name().equals(compatibilityLevel.getCompatibilityLevel())) {
            this.storage.deleteArtifactRule(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), RuleType.COMPATIBILITY);
        }
        return compatibilityLevel;
    }
}

