/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v7.impl;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.logging.audit.Audited;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaId;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.rest.error.ReferenceExistsException;
import io.apicurio.registry.ccompat.rest.error.SchemaNotSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.SchemaSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.ccompat.rest.v7.SubjectVersionsResource;
import io.apicurio.registry.ccompat.rest.v7.impl.AbstractResource;
import io.apicurio.registry.ccompat.rest.v7.impl.ApiConverter;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.util.ContentTypeUtil;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.InvalidArtifactTypeException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import io.apicurio.registry.types.VersionState;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.utils.VersionUtil;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.ws.rs.BadRequestException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SubjectVersionsResourceImpl
extends AbstractResource
implements SubjectVersionsResource {
    @Inject
    ApiConverter converter;

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public List<Integer> listVersions(String subject, String groupId, Boolean deleted) throws Exception {
        boolean fdeleted = deleted == null ? Boolean.FALSE : deleted;
        GA ga = this.getGA(groupId, subject);
        List<Integer> rval = fdeleted ? this.storage.getArtifactVersions(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), RegistryStorage.RetrievalBehavior.DEFAULT).stream().map(VersionUtil::toLong).map(this.converter::convertUnsigned).sorted().collect(Collectors.toList()) : this.storage.getArtifactVersions(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), RegistryStorage.RetrievalBehavior.SKIP_DISABLED_LATEST).stream().map(VersionUtil::toLong).map(this.converter::convertUnsigned).sorted().collect(Collectors.toList());
        if (rval.isEmpty()) {
            throw new ArtifactNotFoundException(ga.getRawGroupIdWithNull(), ga.getRawArtifactId());
        }
        return rval;
    }

    @Override
    @Audited(extractParameters={"0", "artifact_id"})
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public SchemaId register(String subject, SchemaInfo request, Boolean normalize, String groupId) throws Exception {
        boolean fnormalize = normalize == null ? Boolean.FALSE : normalize;
        GA ga = this.getGA(groupId, subject);
        long sid = -1L;
        boolean idFound = false;
        if (null == request) {
            throw new UnprocessableEntityException("The schema provided is null.");
        }
        Map<String, TypedContent> resolvedReferences = this.resolveReferences(request.getReferences());
        try {
            ArtifactVersionMetaDataDto dto = this.lookupSchema(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), request.getSchema(), request.getReferences(), request.getSchemaType(), fnormalize);
            if (dto.getState().equals((Object)VersionState.DISABLED)) {
                throw new ArtifactNotFoundException(ga.getRawGroupIdWithNull(), ga.getRawArtifactId());
            }
            sid = this.cconfig.legacyIdModeEnabled.get() != false ? dto.getGlobalId() : dto.getContentId();
            idFound = true;
        }
        catch (ArtifactNotFoundException dto) {
            // empty catch block
        }
        if (!idFound) {
            try {
                ContentHandle schemaContent = ContentHandle.create((String)request.getSchema());
                String contentType = ContentTypeUtil.determineContentType((ContentHandle)schemaContent);
                TypedContent typedSchemaContent = TypedContent.create((ContentHandle)schemaContent, (String)contentType);
                String artifactType = ArtifactTypeUtil.determineArtifactType(typedSchemaContent, null, resolvedReferences, this.factory);
                if (request.getSchemaType() != null && !artifactType.equals(request.getSchemaType())) {
                    throw new UnprocessableEntityException(String.format("Given schema is not from type: %s", request.getSchemaType()));
                }
                ArtifactVersionMetaDataDto artifactMeta = this.createOrUpdateArtifact(ga.getRawArtifactId(), request.getSchema(), artifactType, request.getReferences(), ga.getRawGroupIdWithNull());
                sid = this.cconfig.legacyIdModeEnabled.get() != false ? artifactMeta.getGlobalId() : artifactMeta.getContentId();
            }
            catch (InvalidArtifactTypeException ex) {
                throw new UnprocessableEntityException(ex.getMessage());
            }
        }
        int id = this.converter.convertUnsigned(sid);
        return new SchemaId(id);
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public Schema getSchemaByVersion(String subject, String version, String groupId, Boolean deleted) throws Exception {
        boolean fdeleted = deleted == null ? Boolean.FALSE : deleted;
        GA ga = this.getGA(groupId, subject);
        return this.getSchema(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), version, fdeleted);
    }

    @Override
    @Audited(extractParameters={"0", "artifact_id", "1", "version"})
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public int deleteSchemaVersion(String subject, String versionString, Boolean permanent, String groupId) throws Exception {
        GA ga = this.getGA(groupId, subject);
        try {
            if (this.doesArtifactExist(ga.getRawArtifactId(), ga.getRawGroupIdWithNull())) {
                boolean fpermanent = permanent == null ? Boolean.FALSE : permanent;
                return VersionUtil.toInteger(this.parseVersionString(ga.getRawArtifactId(), versionString, ga.getRawGroupIdWithNull(), version -> {
                    List<Long> globalIdsReferencingSchema = this.storage.getGlobalIdsReferencingArtifactVersion(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), (String)version);
                    ArtifactVersionMetaDataDto avmd = this.storage.getArtifactVersionMetaData(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), (String)version);
                    if (globalIdsReferencingSchema.isEmpty() || this.areAllSchemasDisabled(globalIdsReferencingSchema)) {
                        return this.processDeleteVersion(ga.getRawArtifactId(), versionString, ga.getRawGroupIdWithNull(), (String)version, fpermanent, avmd);
                    }
                    throw new ReferenceExistsException(String.format("There are subjects referencing %s", ga.getRawArtifactId()));
                }));
            }
            throw new ArtifactNotFoundException(ga.getRawGroupIdWithNull(), ga.getRawArtifactId());
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequestException((Throwable)ex);
        }
    }

    private String processDeleteVersion(String artifactId, String versionString, String groupId, String version, boolean fpermanent, ArtifactVersionMetaDataDto avmd) {
        if (fpermanent) {
            if (avmd.getState().equals((Object)VersionState.ENABLED) || avmd.getState().equals((Object)VersionState.DEPRECATED)) {
                throw new SchemaNotSoftDeletedException(String.format("Subject %s version %s must be soft deleted first", artifactId, versionString));
            }
            if (avmd.getState().equals((Object)VersionState.DISABLED)) {
                this.storage.deleteArtifactVersion(groupId, artifactId, version);
            }
        } else {
            if (avmd.getState().equals((Object)VersionState.DISABLED)) {
                throw new SchemaSoftDeletedException("Schema is already soft deleted");
            }
            EditableVersionMetaDataDto emd = EditableVersionMetaDataDto.builder().state(VersionState.DISABLED).build();
            this.storage.updateArtifactVersionMetaData(groupId, artifactId, version, emd);
        }
        return version;
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public String getSchemaOnly(String subject, String version, String groupId, Boolean deleted) throws Exception {
        boolean fdeleted = deleted == null ? Boolean.FALSE : deleted;
        GA ga = this.getGA(groupId, subject);
        return this.getSchema(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), version, fdeleted).getSchema();
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public List<Long> getSchemasReferencedBy(String subject, String versionString, String groupId) throws Exception {
        GA ga = this.getGA(groupId, subject);
        if (this.cconfig.legacyIdModeEnabled.get().booleanValue()) {
            return this.parseVersionString(ga.getRawArtifactId(), versionString, ga.getRawGroupIdWithNull(), version -> this.storage.getGlobalIdsReferencingArtifactVersion(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), (String)version));
        }
        return this.parseVersionString(ga.getRawArtifactId(), versionString, ga.getRawGroupIdWithNull(), version -> this.storage.getContentIdsReferencingArtifactVersion(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), (String)version));
    }

    protected Schema getSchema(String groupId, String artifactId, String versionString, boolean deleted) {
        if (this.doesArtifactExist(artifactId, groupId) && this.isArtifactActive(artifactId, groupId)) {
            return this.parseVersionString(artifactId, versionString, groupId, version -> {
                ArtifactVersionMetaDataDto amd = this.storage.getArtifactVersionMetaData(groupId, artifactId, (String)version);
                if (amd.getState() != VersionState.DISABLED || deleted) {
                    StoredArtifactVersionDto storedArtifact = this.storage.getArtifactVersionContent(groupId, artifactId, amd.getVersion());
                    return this.converter.convert(artifactId, storedArtifact, amd.getArtifactType());
                }
                throw new VersionNotFoundException(groupId, artifactId, (String)version);
            });
        }
        throw new ArtifactNotFoundException(groupId, artifactId);
    }
}

