/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v7.impl;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.logging.audit.Audited;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.rest.error.SchemaNotFoundException;
import io.apicurio.registry.ccompat.rest.error.SubjectNotSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.SubjectSoftDeletedException;
import io.apicurio.registry.ccompat.rest.v7.SubjectsResource;
import io.apicurio.registry.ccompat.rest.v7.impl.AbstractResource;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.SearchedArtifactDto;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.InvalidArtifactStateException;
import io.apicurio.registry.storage.error.InvalidVersionStateException;
import io.apicurio.registry.types.VersionState;
import io.apicurio.registry.utils.VersionUtil;
import jakarta.interceptor.Interceptors;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SubjectsResourceImpl
extends AbstractResource
implements SubjectsResource {
    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public List<String> listSubjects(String subjectPrefix, Boolean deleted, String groupId) {
        boolean fdeleted = deleted == null ? Boolean.FALSE : deleted;
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        if (!this.cconfig.groupConcatEnabled) {
            filters.add(SearchFilter.ofGroupId(groupId));
        }
        if (!fdeleted) {
            filters.add(SearchFilter.ofState(VersionState.DISABLED).negated());
        }
        ArtifactSearchResultsDto searchResults = this.storage.searchArtifacts(filters, OrderBy.createdOn, OrderDirection.asc, 0, this.cconfig.maxSubjects.get());
        Function<SearchedArtifactDto, String> toSubject = SearchedArtifactDto::getArtifactId;
        if (this.cconfig.groupConcatEnabled) {
            toSubject = dto -> this.toSubjectWithGroupConcat((SearchedArtifactDto)dto);
        }
        return searchResults.getArtifacts().stream().filter(saDto -> this.isCcompatManagedType(saDto.getArtifactType())).map(toSubject).collect(Collectors.toList());
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public Schema findSchemaByContent(String subject, SchemaInfo request, Boolean normalize, String groupId, Boolean deleted) throws Exception {
        GA ga = this.getGA(groupId, subject);
        if (this.doesArtifactExist(ga.getRawArtifactId(), ga.getRawGroupIdWithNull())) {
            boolean fnormalize = normalize == null ? Boolean.FALSE : normalize;
            boolean fdeleted = deleted == null ? Boolean.FALSE : deleted;
            try {
                ArtifactVersionMetaDataDto amd = this.lookupSchema(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), request.getSchema(), request.getReferences(), request.getSchemaType(), fnormalize);
                if (amd.getState() != VersionState.DISABLED || fdeleted) {
                    StoredArtifactVersionDto storedArtifact = this.storage.getArtifactVersionContent(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), amd.getVersion());
                    return this.converter.convert(ga.getRawArtifactId(), storedArtifact);
                }
                throw new SchemaNotFoundException(String.format("The given schema does not match any schema under the subject %s", ga.getRawArtifactId()));
            }
            catch (ArtifactNotFoundException anf) {
                throw new SchemaNotFoundException(String.format("The given schema does not match any schema under the subject %s", ga.getRawArtifactId()));
            }
        }
        throw new ArtifactNotFoundException(ga.getRawGroupIdWithNull(), ga.getRawArtifactId());
    }

    @Override
    @Audited(extractParameters={"0", "artifact_id"})
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public List<Integer> deleteSubject(String subject, Boolean permanent, String groupId) throws Exception {
        GA ga = this.getGA(groupId, subject);
        this.storage.getArtifactMetaData(ga.getRawGroupIdWithNull(), ga.getRawArtifactId());
        boolean fpermanent = permanent == null ? Boolean.FALSE : permanent;
        if (fpermanent) {
            return this.deleteSubjectPermanent(ga.getRawGroupIdWithNull(), ga.getRawArtifactId());
        }
        if (this.isArtifactActive(ga.getRawArtifactId(), ga.getRawGroupIdWithNull())) {
            return this.deleteSubjectVersions(ga.getRawGroupIdWithNull(), ga.getRawArtifactId());
        }
        throw new SubjectSoftDeletedException(String.format("Subject %s is in soft deleted state.", ga.getRawArtifactId()));
    }

    private List<Integer> deleteSubjectPermanent(String groupId, String artifactId) {
        if (this.isArtifactActive(artifactId, groupId)) {
            throw new SubjectNotSoftDeletedException(String.format("Subject %s must be soft deleted first", artifactId));
        }
        return this.storage.deleteArtifact(groupId, artifactId).stream().map(VersionUtil::toInteger).map(this.converter::convertUnsigned).collect(Collectors.toList());
    }

    private List<Integer> deleteSubjectVersions(String groupId, String artifactId) {
        List<String> deletedVersions = this.storage.getArtifactVersions(groupId, artifactId);
        try {
            EditableVersionMetaDataDto dto = EditableVersionMetaDataDto.builder().state(VersionState.DISABLED).build();
            deletedVersions.forEach(version -> this.storage.updateArtifactVersionMetaData(groupId, artifactId, (String)version, dto));
        }
        catch (InvalidArtifactStateException | InvalidVersionStateException ignored) {
            this.log.warn("Invalid artifact state transition", (Throwable)ignored);
        }
        return deletedVersions.stream().map(VersionUtil::toLong).map(this.converter::convertUnsigned).sorted().collect(Collectors.toList());
    }
}

