/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.config;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.storage.decorator.RegistryStorageDecorator;
import io.apicurio.registry.storage.decorator.RegistryStorageDecoratorBase;
import io.apicurio.registry.storage.error.RegistryStorageException;
import io.quarkus.scheduler.Scheduled;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryStorageConfigCache
extends RegistryStorageDecoratorBase
implements RegistryStorageDecorator {
    private static final DynamicConfigPropertyDto NULL_DTO = new DynamicConfigPropertyDto();
    @Inject
    Logger log;
    @ConfigProperty(name="apicurio.config.cache.enabled", defaultValue="true")
    @Info(category="cache", description="Registry cache enabled", availableSince="2.2.2.Final")
    boolean enabled;
    private Map<String, DynamicConfigPropertyDto> configCache = new ConcurrentHashMap<String, DynamicConfigPropertyDto>();
    private Instant lastRefresh = null;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int order() {
        return 40;
    }

    @Override
    public void setConfigProperty(DynamicConfigPropertyDto property) throws RegistryStorageException {
        super.setConfigProperty(property);
        this.invalidateCache();
    }

    @Override
    public DynamicConfigPropertyDto getConfigProperty(String propertyName) {
        DynamicConfigPropertyDto propertyDto = this.configCache.computeIfAbsent(propertyName, key -> {
            DynamicConfigPropertyDto dto = super.getConfigProperty((String)key);
            if (dto == null) {
                dto = NULL_DTO;
            }
            return dto;
        });
        return propertyDto == NULL_DTO ? null : propertyDto;
    }

    private void invalidateCache() {
        this.configCache.clear();
    }

    @Scheduled(concurrentExecution=Scheduled.ConcurrentExecution.SKIP, every="{apicurio.config.refresh.every}")
    void run() {
        if (!this.enabled) {
            return;
        }
        try {
            this.log.debug("Running config property refresh job at {}", (Object)Instant.now());
            this.refresh();
        }
        catch (Exception ex) {
            this.log.error("Exception thrown when running config property refresh job.", (Throwable)ex);
        }
    }

    private void refresh() {
        List<DynamicConfigPropertyDto> staleConfigProperties;
        Instant now = Instant.now();
        if (this.lastRefresh != null && this.delegate != null && this.delegate.isReady() && !(staleConfigProperties = this.getStaleConfigProperties(this.lastRefresh)).isEmpty()) {
            this.invalidateCache();
        }
        this.lastRefresh = now;
    }
}

