/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.OutboxEvent;
import java.util.UUID;
import org.json.JSONObject;

public class ArtifactCreated
extends OutboxEvent {
    private final JSONObject eventPayload;

    private ArtifactCreated(String id, String aggregateId, JSONObject eventPayload) {
        super(id, aggregateId);
        this.eventPayload = eventPayload;
    }

    public static ArtifactCreated of(ArtifactMetaDataDto artifactMetaDataDto) {
        String id = UUID.randomUUID().toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id).put("groupId", (Object)artifactMetaDataDto.getGroupId()).put("artifactId", (Object)artifactMetaDataDto.getArtifactId()).put("name", (Object)artifactMetaDataDto.getName()).put("description", (Object)artifactMetaDataDto.getDescription()).put("eventType", (Object)StorageEventType.ARTIFACT_CREATED.name());
        return new ArtifactCreated(id, artifactMetaDataDto.getGroupId() + "-" + artifactMetaDataDto.getArtifactId(), jsonObject);
    }

    @Override
    public String getType() {
        return StorageEventType.ARTIFACT_CREATED.name();
    }

    @Override
    public JSONObject getPayload() {
        return this.eventPayload;
    }
}

