/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.OutboxEvent;
import java.util.UUID;
import org.json.JSONObject;

public class ArtifactDeleted
extends OutboxEvent {
    private final JSONObject eventPayload;

    private ArtifactDeleted(String id, String aggregateId, JSONObject eventPayload) {
        super(id, aggregateId);
        this.eventPayload = eventPayload;
    }

    public static ArtifactDeleted of(String groupId, String artifactId) {
        String id = UUID.randomUUID().toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id).put("groupId", (Object)groupId).put("artifactId", (Object)artifactId).put("eventType", (Object)StorageEventType.ARTIFACT_DELETED.name());
        return new ArtifactDeleted(id, groupId + "-" + artifactId, jsonObject);
    }

    @Override
    public String getType() {
        return StorageEventType.ARTIFACT_DELETED.name();
    }

    @Override
    public JSONObject getPayload() {
        return this.eventPayload;
    }
}

