/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.OutboxEvent;
import java.util.UUID;
import org.json.JSONObject;

public class ArtifactMetadataUpdated
extends OutboxEvent {
    private final JSONObject eventPayload;

    private ArtifactMetadataUpdated(String id, String aggregateId, JSONObject eventPayload) {
        super(id, aggregateId);
        this.eventPayload = eventPayload;
    }

    public static ArtifactMetadataUpdated of(String groupId, String artifactId, EditableArtifactMetaDataDto artifactMetaDataDto) {
        String id = UUID.randomUUID().toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id).put("groupId", (Object)groupId).put("artifactId", (Object)artifactId).put("name", (Object)artifactMetaDataDto.getName()).put("owner", (Object)artifactMetaDataDto.getOwner()).put("description", (Object)artifactMetaDataDto.getDescription()).put("eventType", (Object)StorageEventType.ARTIFACT_METADATA_UPDATED.name());
        return new ArtifactMetadataUpdated(id, groupId + "-" + artifactId, jsonObject);
    }

    @Override
    public String getType() {
        return StorageEventType.ARTIFACT_METADATA_UPDATED.name();
    }

    @Override
    public JSONObject getPayload() {
        return this.eventPayload;
    }
}

