/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.OutboxEvent;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.types.RuleType;
import java.util.UUID;
import org.json.JSONObject;

public class ArtifactRuleConfigured
extends OutboxEvent {
    private final JSONObject eventPayload;

    private ArtifactRuleConfigured(String id, String aggregateId, JSONObject eventPayload) {
        super(id, aggregateId);
        this.eventPayload = eventPayload;
    }

    public static ArtifactRuleConfigured of(String groupId, String artifactId, RuleType ruleType, RuleConfigurationDto rule) {
        String id = UUID.randomUUID().toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id).put("groupId", (Object)groupId).put("artifactId", (Object)artifactId).put("ruleType", (Object)ruleType.value()).put("rule", (Object)rule.getConfiguration()).put("eventType", (Object)StorageEventType.ARTIFACT_RULE_CONFIGURED.name());
        return new ArtifactRuleConfigured(id, groupId + "-" + artifactId, jsonObject);
    }

    @Override
    public String getType() {
        return StorageEventType.ARTIFACT_RULE_CONFIGURED.name();
    }

    @Override
    public JSONObject getPayload() {
        return this.eventPayload;
    }
}

