/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.OutboxEvent;
import java.util.UUID;
import org.json.JSONObject;

public class ArtifactVersionCreated
extends OutboxEvent {
    private final JSONObject eventPayload;

    private ArtifactVersionCreated(String id, String aggregateId, JSONObject eventPayload) {
        super(id, aggregateId);
        this.eventPayload = eventPayload;
    }

    public static ArtifactVersionCreated of(ArtifactVersionMetaDataDto versionMetaDataDto) {
        String id = UUID.randomUUID().toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id).put("groupId", (Object)versionMetaDataDto.getGroupId()).put("artifactId", (Object)versionMetaDataDto.getArtifactId()).put("version", (Object)versionMetaDataDto.getVersion()).put("name", (Object)versionMetaDataDto.getName()).put("description", (Object)versionMetaDataDto.getDescription()).put("eventType", (Object)StorageEventType.ARTIFACT_VERSION_CREATED.name());
        return new ArtifactVersionCreated(id, versionMetaDataDto.getGroupId() + "-" + versionMetaDataDto.getArtifactId() + "-" + versionMetaDataDto.getVersion(), jsonObject);
    }

    @Override
    public String getType() {
        return StorageEventType.ARTIFACT_VERSION_CREATED.name();
    }

    @Override
    public JSONObject getPayload() {
        return this.eventPayload;
    }
}

