/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.OutboxEvent;
import java.util.UUID;
import org.json.JSONObject;

public class ArtifactVersionDeleted
extends OutboxEvent {
    private final JSONObject eventPayload;

    private ArtifactVersionDeleted(String id, String aggregateId, JSONObject eventPayload) {
        super(id, aggregateId);
        this.eventPayload = eventPayload;
    }

    public static ArtifactVersionDeleted of(String groupId, String artifactId, String version) {
        String id = UUID.randomUUID().toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id).put("groupId", (Object)groupId).put("artifactId", (Object)artifactId).put("version", (Object)version).put("eventType", (Object)StorageEventType.ARTIFACT_VERSION_DELETED.name());
        return new ArtifactVersionDeleted(id, groupId + "-" + artifactId + "-" + version, jsonObject);
    }

    @Override
    public String getType() {
        return StorageEventType.ARTIFACT_VERSION_DELETED.name();
    }

    @Override
    public JSONObject getPayload() {
        return this.eventPayload;
    }
}

