/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.dto.OutboxEvent;
import java.util.UUID;
import org.json.JSONObject;

public class ArtifactVersionMetadataUpdated
extends OutboxEvent {
    private final JSONObject eventPayload;

    private ArtifactVersionMetadataUpdated(String id, String aggregateId, JSONObject eventPayload) {
        super(id, aggregateId);
        this.eventPayload = eventPayload;
    }

    public static ArtifactVersionMetadataUpdated of(String groupId, String artifactId, String version, EditableVersionMetaDataDto editableVersionMetaDataDto) {
        String id = UUID.randomUUID().toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id).put("groupId", (Object)groupId).put("artifactId", (Object)artifactId).put("version", (Object)version).put("name", (Object)editableVersionMetaDataDto.getName()).put("description", (Object)editableVersionMetaDataDto.getDescription()).put("eventType", (Object)StorageEventType.ARTIFACT_VERSION_METADATA_UPDATED.name());
        return new ArtifactVersionMetadataUpdated(id, groupId + "-" + artifactId + "-" + version, jsonObject);
    }

    @Override
    public String getType() {
        return StorageEventType.ARTIFACT_VERSION_METADATA_UPDATED.name();
    }

    @Override
    public JSONObject getPayload() {
        return this.eventPayload;
    }
}

