/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.OutboxEvent;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.types.RuleType;
import java.util.UUID;
import org.json.JSONObject;

public class GlobalRuleConfigured
extends OutboxEvent {
    private final JSONObject eventPayload;

    private GlobalRuleConfigured(String id, String aggregateId, JSONObject eventPayload) {
        super(id, aggregateId);
        this.eventPayload = eventPayload;
    }

    public static GlobalRuleConfigured of(RuleType ruleType, RuleConfigurationDto rule) {
        String id = UUID.randomUUID().toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id).put("ruleType", (Object)ruleType.value()).put("rule", (Object)rule.getConfiguration()).put("eventType", (Object)StorageEventType.GLOBAL_RULE_CONFIGURED.name());
        return new GlobalRuleConfigured(id, ruleType.value(), jsonObject);
    }

    @Override
    public String getType() {
        return StorageEventType.GLOBAL_RULE_CONFIGURED.name();
    }

    @Override
    public JSONObject getPayload() {
        return this.eventPayload;
    }
}

