/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.OutboxEvent;
import java.util.UUID;
import org.json.JSONObject;

public class GroupCreated
extends OutboxEvent {
    private final JSONObject eventPayload;

    private GroupCreated(String id, String aggregateId, JSONObject eventPayload) {
        super(id, aggregateId);
        this.eventPayload = eventPayload;
    }

    public static GroupCreated of(GroupMetaDataDto groupMetaDataDto) {
        String id = UUID.randomUUID().toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id).put("groupId", (Object)groupMetaDataDto.getGroupId()).put("eventType", (Object)StorageEventType.GROUP_CREATED.name());
        return new GroupCreated(id, groupMetaDataDto.getGroupId(), jsonObject);
    }

    @Override
    public String getType() {
        return StorageEventType.GROUP_CREATED.name();
    }

    @Override
    public JSONObject getPayload() {
        return this.eventPayload;
    }
}

