/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.OutboxEvent;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.types.RuleType;
import java.util.UUID;
import org.json.JSONObject;

public class GroupRuleConfigured
extends OutboxEvent {
    private final JSONObject eventPayload;

    private GroupRuleConfigured(String id, String aggregateId, JSONObject eventPayload) {
        super(id, aggregateId);
        this.eventPayload = eventPayload;
    }

    public static GroupRuleConfigured of(String groupId, RuleType ruleType, RuleConfigurationDto rule) {
        String id = UUID.randomUUID().toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id).put("groupId", (Object)groupId).put("ruleType", (Object)ruleType.value()).put("rule", (Object)rule.getConfiguration()).put("eventType", (Object)StorageEventType.GROUP_RULE_CONFIGURED.name());
        return new GroupRuleConfigured(id, groupId, jsonObject);
    }

    @Override
    public String getType() {
        return StorageEventType.GROUP_RULE_CONFIGURED.name();
    }

    @Override
    public JSONObject getPayload() {
        return this.eventPayload;
    }
}

