/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.limits;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.limits.LimitsCheckResult;
import io.apicurio.registry.limits.RegistryLimitsConfiguration;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.metrics.StorageMetricsStore;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryLimitsService {
    private static final String MAX_TOTAL_SCHEMAS_EXCEEDED_MSG = "Maximum number of artifact versions exceeded";
    private static final String MAX_SCHEMA_SIZE_EXCEEDED_MSG = "Maximum size of artifact version exceeded";
    private static final String MAX_ARTIFACTS_EXCEEDED_MSG = "Maximum number of artifacts exceeded";
    private static final String MAX_VERSIONS_PER_ARTIFACT_EXCEEDED_MSG = "Maximum number of versions exceeded for this artifact";
    private static final String MAX_NAME_LENGTH_EXCEEDED_MSG = "Maximum artifact name length exceeded";
    private static final String MAX_DESC_LENGTH_EXCEEDED_MSG = "Maximum artifact description length exceeded";
    private static final String MAX_LABELS_EXCEEDED_MSG = "Maximum number of labels exceeded for this artifact";
    private static final String MAX_LABEL_KEY_SIZE_EXCEEDED_MSG = "Maximum label key size exceeded";
    private static final String MAX_LABEL_VALUE_SIZE_EXCEEDED_MSG = "Maximum label value size exceeded";
    @Inject
    Logger log;
    @Inject
    StorageMetricsStore storageMetricsStore;
    @Inject
    RegistryLimitsConfiguration registryLimitsConfiguration;

    private LimitsCheckResult checkTotalSchemas() {
        if (this.isLimitDisabled(RegistryLimitsConfiguration::getMaxTotalSchemasCount)) {
            return LimitsCheckResult.ok();
        }
        long currentTotalSchemas = this.storageMetricsStore.getOrInitializeTotalSchemasCounter();
        if (currentTotalSchemas < this.registryLimitsConfiguration.getMaxTotalSchemasCount()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, current total schemas {} , max total schemas {}", (Object)currentTotalSchemas, (Object)this.registryLimitsConfiguration.getMaxTotalSchemasCount());
        return LimitsCheckResult.disallowed(MAX_TOTAL_SCHEMAS_EXCEEDED_MSG);
    }

    public LimitsCheckResult canCreateArtifact(EditableArtifactMetaDataDto meta, ContentWrapperDto versionContent, EditableVersionMetaDataDto versionMetaData) {
        LimitsCheckResult vmr;
        LimitsCheckResult ssr;
        LimitsCheckResult mr = this.checkMetaData(meta);
        if (!mr.isAllowed()) {
            return mr;
        }
        LimitsCheckResult tsr = this.checkTotalSchemas();
        if (!tsr.isAllowed()) {
            return tsr;
        }
        if (versionContent != null && !(ssr = this.checkSchemaSize(versionContent.getContent())).isAllowed()) {
            return ssr;
        }
        if (versionMetaData != null && !(vmr = this.checkMetaData(versionMetaData)).isAllowed()) {
            return vmr;
        }
        if (this.isLimitDisabled(RegistryLimitsConfiguration::getMaxArtifactsCount)) {
            return LimitsCheckResult.ok();
        }
        long currentArtifacts = this.storageMetricsStore.getOrInitializeArtifactsCounter();
        if (currentArtifacts < this.registryLimitsConfiguration.getMaxArtifactsCount()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, current artifacts {} , max artifacts allowed {}", (Object)currentArtifacts, (Object)this.registryLimitsConfiguration.getMaxArtifactsCount());
        return LimitsCheckResult.disallowed(MAX_ARTIFACTS_EXCEEDED_MSG);
    }

    private LimitsCheckResult checkSchemaSize(ContentHandle content) {
        if (this.isLimitDisabled(RegistryLimitsConfiguration::getMaxSchemaSizeBytes) || content == null) {
            return LimitsCheckResult.ok();
        }
        int size = content.getSizeBytes();
        if ((long)size <= this.registryLimitsConfiguration.getMaxSchemaSizeBytes()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, schema size is {} , max schema size is {}", (Object)size, (Object)this.registryLimitsConfiguration.getMaxSchemaSizeBytes());
        return LimitsCheckResult.disallowed(MAX_SCHEMA_SIZE_EXCEEDED_MSG);
    }

    public LimitsCheckResult canCreateArtifactVersion(String groupId, String artifactId, EditableVersionMetaDataDto meta, ContentHandle content) {
        LimitsCheckResult mr = this.checkMetaData(meta);
        if (!mr.isAllowed()) {
            return mr;
        }
        LimitsCheckResult tsr = this.checkTotalSchemas();
        if (!tsr.isAllowed()) {
            return tsr;
        }
        LimitsCheckResult ssr = this.checkSchemaSize(content);
        if (!ssr.isAllowed()) {
            return ssr;
        }
        if (this.isLimitDisabled(RegistryLimitsConfiguration::getMaxVersionsPerArtifactCount)) {
            return LimitsCheckResult.ok();
        }
        long currentArtifactVersions = this.storageMetricsStore.getOrInitializeArtifactVersionsCounter(groupId, artifactId);
        if (currentArtifactVersions < this.registryLimitsConfiguration.getMaxVersionsPerArtifactCount()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, current versions per artifact for artifact {}/{} {} , max versions per artifacts allowed {}", new Object[]{groupId, artifactId, currentArtifactVersions, this.registryLimitsConfiguration.getMaxVersionsPerArtifactCount()});
        return LimitsCheckResult.disallowed(MAX_VERSIONS_PER_ARTIFACT_EXCEEDED_MSG);
    }

    public void artifactCreated() {
        this.storageMetricsStore.incrementTotalSchemasCounter();
        this.storageMetricsStore.incrementArtifactsCounter();
    }

    public void artifactVersionCreated(String groupId, String artifactId) {
        this.storageMetricsStore.incrementTotalSchemasCounter();
        this.storageMetricsStore.incrementArtifactVersionsCounter(groupId, artifactId);
    }

    public void artifactDeleted() {
        this.storageMetricsStore.resetTotalSchemasCounter();
        this.storageMetricsStore.resetArtifactsCounter();
    }

    public void artifactVersionDeleted(String groupId, String artifactId) {
        this.storageMetricsStore.resetTotalSchemasCounter();
        this.storageMetricsStore.resetArtifactVersionsCounter(groupId, artifactId);
    }

    public LimitsCheckResult checkMetaData(EditableArtifactMetaDataDto meta) {
        if (meta == null || this.registryLimitsConfiguration == null) {
            return LimitsCheckResult.ok();
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        this.checkName(meta.getName(), errorMessages);
        this.checkDescription(meta.getDescription(), errorMessages);
        this.checkLabels(meta.getLabels(), errorMessages);
        if (errorMessages.isEmpty()) {
            return LimitsCheckResult.ok();
        }
        return LimitsCheckResult.disallowed(String.join((CharSequence)", ", errorMessages));
    }

    public LimitsCheckResult checkMetaData(EditableVersionMetaDataDto meta) {
        if (meta == null || this.registryLimitsConfiguration == null) {
            return LimitsCheckResult.ok();
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        this.checkName(meta.getName(), errorMessages);
        this.checkDescription(meta.getDescription(), errorMessages);
        this.checkLabels(meta.getLabels(), errorMessages);
        if (errorMessages.isEmpty()) {
            return LimitsCheckResult.ok();
        }
        return LimitsCheckResult.disallowed(String.join((CharSequence)", ", errorMessages));
    }

    protected void checkName(String name, List<String> errorMessages) {
        if (name != null && this.isLimitEnabled(RegistryLimitsConfiguration::getMaxArtifactNameLengthChars) && (long)name.length() > this.registryLimitsConfiguration.getMaxArtifactNameLengthChars()) {
            errorMessages.add(MAX_NAME_LENGTH_EXCEEDED_MSG);
        }
    }

    protected void checkDescription(String description, List<String> errorMessages) {
        if (description != null && this.isLimitEnabled(RegistryLimitsConfiguration::getMaxArtifactDescriptionLengthChars) && (long)description.length() > this.registryLimitsConfiguration.getMaxArtifactDescriptionLengthChars()) {
            errorMessages.add(MAX_DESC_LENGTH_EXCEEDED_MSG);
        }
    }

    protected void checkLabels(Map<String, String> labels, List<String> errorMessages) {
        if (labels != null) {
            if (this.isLimitEnabled(RegistryLimitsConfiguration::getMaxArtifactPropertiesCount) && (long)labels.size() > this.registryLimitsConfiguration.getMaxArtifactPropertiesCount()) {
                errorMessages.add(MAX_LABELS_EXCEEDED_MSG);
            } else if (this.isLimitEnabled(RegistryLimitsConfiguration::getMaxPropertyKeySizeBytes) || this.isLimitEnabled(RegistryLimitsConfiguration::getMaxPropertyValueSizeBytes)) {
                labels.entrySet().forEach(e -> {
                    if (this.isLimitEnabled(RegistryLimitsConfiguration::getMaxPropertyKeySizeBytes) && (long)((String)e.getKey()).length() > this.registryLimitsConfiguration.getMaxPropertyKeySizeBytes()) {
                        errorMessages.add(MAX_LABEL_KEY_SIZE_EXCEEDED_MSG);
                    }
                    if (this.isLimitEnabled(RegistryLimitsConfiguration::getMaxPropertyValueSizeBytes) && (long)((String)e.getValue()).length() > this.registryLimitsConfiguration.getMaxPropertyValueSizeBytes()) {
                        errorMessages.add(MAX_LABEL_VALUE_SIZE_EXCEEDED_MSG);
                    }
                });
            }
        }
    }

    private boolean isLimitEnabled(Function<RegistryLimitsConfiguration, Long> limitGetter) {
        Long limit;
        return this.registryLimitsConfiguration != null && (limit = limitGetter.apply(this.registryLimitsConfiguration)) != null && limit >= 0L;
    }

    private boolean isLimitDisabled(Function<RegistryLimitsConfiguration, Long> limitGetter) {
        return !this.isLimitEnabled(limitGetter);
    }
}

