/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.limits;

import io.apicurio.registry.limits.LimitExceededException;
import io.apicurio.registry.limits.LimitsCheckResult;
import io.apicurio.registry.limits.RegistryLimitsConfigurationProducer;
import io.apicurio.registry.limits.RegistryLimitsService;
import io.apicurio.registry.storage.decorator.RegistryStorageDecorator;
import io.apicurio.registry.storage.decorator.RegistryStorageDecoratorBase;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.RegistryStorageException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.microprofile.context.ThreadContext;

@ApplicationScoped
public class RegistryStorageLimitsEnforcer
extends RegistryStorageDecoratorBase
implements RegistryStorageDecorator {
    @Inject
    ThreadContext threadContext;
    @Inject
    RegistryLimitsService limitsService;
    @Inject
    RegistryLimitsConfigurationProducer limitsConfiguration;

    @Override
    public boolean isEnabled() {
        return this.limitsConfiguration.isConfigured();
    }

    @Override
    public int order() {
        return 30;
    }

    @Override
    public Pair<ArtifactMetaDataDto, ArtifactVersionMetaDataDto> createArtifact(String groupId, String artifactId, String artifactType, EditableArtifactMetaDataDto artifactMetaData, String version, ContentWrapperDto versionContent, EditableVersionMetaDataDto versionMetaData, List<String> versionBranches, boolean dryRun) throws RegistryStorageException {
        Pair rval = (Pair)this.withLimitsCheck(() -> this.limitsService.canCreateArtifact(artifactMetaData, versionContent, versionMetaData)).execute(() -> super.createArtifact(groupId, artifactId, artifactType, artifactMetaData, version, versionContent, versionMetaData, versionBranches, dryRun));
        this.limitsService.artifactCreated();
        return rval;
    }

    @Override
    public ArtifactVersionMetaDataDto createArtifactVersion(String groupId, String artifactId, String version, String artifactType, ContentWrapperDto content, EditableVersionMetaDataDto metaData, List<String> branches, boolean dryRun) throws RegistryStorageException {
        ArtifactVersionMetaDataDto dto = (ArtifactVersionMetaDataDto)this.withLimitsCheck(() -> this.limitsService.canCreateArtifactVersion(groupId, artifactId, null, content.getContent())).execute(() -> super.createArtifactVersion(groupId, artifactId, version, artifactType, content, metaData, branches, dryRun));
        this.limitsService.artifactVersionCreated(groupId, artifactId);
        return dto;
    }

    @Override
    public void updateArtifactMetaData(String groupId, String artifactId, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException {
        this.withLimitsCheck(() -> this.limitsService.checkMetaData(metaData)).execute(() -> {
            super.updateArtifactMetaData(groupId, artifactId, metaData);
            return null;
        });
    }

    @Override
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableVersionMetaDataDto metaData) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.withLimitsCheck(() -> this.limitsService.checkMetaData(metaData)).execute(() -> {
            super.updateArtifactVersionMetaData(groupId, artifactId, version, metaData);
            return null;
        });
    }

    @Override
    public List<String> deleteArtifact(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        List<String> ids = super.deleteArtifact(groupId, artifactId);
        this.limitsService.artifactDeleted();
        return ids;
    }

    @Override
    public void deleteArtifacts(String groupId) throws RegistryStorageException {
        super.deleteArtifacts(groupId);
        this.limitsService.artifactDeleted();
    }

    @Override
    public void deleteArtifactVersion(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        super.deleteArtifactVersion(groupId, artifactId, version);
        this.limitsService.artifactVersionDeleted(groupId, artifactId);
    }

    public LimitedActionExecutor withLimitsCheck(final LimitsChecker checker) {
        return new LimitedActionExecutor(){

            @Override
            public <T> T execute(LimitedAction<T> action) {
                LimitsCheckResult r = (LimitsCheckResult)checker.get();
                if (r.isAllowed()) {
                    Object result = action.get();
                    if (result instanceof CompletionStage) {
                        result = RegistryStorageLimitsEnforcer.this.threadContext.withContextCapture((CompletionStage)result);
                    }
                    return result;
                }
                throw new LimitExceededException(r.getMessage());
            }
        };
    }

    @FunctionalInterface
    private static interface LimitsChecker
    extends Supplier<LimitsCheckResult> {
    }

    @FunctionalInterface
    private static interface LimitedActionExecutor {
        public <T> T execute(LimitedAction<T> var1);
    }

    @FunctionalInterface
    private static interface LimitedAction<T>
    extends Supplier<T> {
    }
}

