/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.regex.Pattern;

@Provider
@Default
@ApplicationScoped
public class RestMetricsResponseFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Inject
    MeterRegistry registry;
    public static final String TIMER_SAMPLE_CONTEXT_PROPERTY_NAME = "request-timer-sample";
    @Context
    private ResourceInfo resourceInfo;
    static final Pattern ENABLED_PATTERN = Pattern.compile("/apis/.*");

    public void filter(ContainerRequestContext requestContext) throws IOException {
        boolean enabled = ENABLED_PATTERN.matcher(requestContext.getUriInfo().getPath()).matches();
        if (enabled) {
            Timer.Sample sample = Timer.start((MeterRegistry)this.registry);
            requestContext.setProperty(TIMER_SAMPLE_CONTEXT_PROPERTY_NAME, (Object)sample);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (requestContext.getProperty(TIMER_SAMPLE_CONTEXT_PROPERTY_NAME) == null) {
            return;
        }
        Timer timer = Timer.builder((String)"rest.requests").description("Timing and results of REST endpoints calls").tag("path", this.getPath()).tag("method", requestContext.getMethod()).tag("status_code_group", this.getStatusGroup(responseContext.getStatus())).register(this.registry);
        Timer.Sample sample = (Timer.Sample)requestContext.getProperty(TIMER_SAMPLE_CONTEXT_PROPERTY_NAME);
        sample.stop(timer);
        Counter.builder((String)"rest.requests.count").description("Count and results of REST endpoints calls").tag("path", this.getPath()).tag("method", requestContext.getMethod()).tag("status_code_group", this.getStatusGroup(responseContext.getStatus())).register(this.registry).increment();
    }

    private String getStatusGroup(int statusCode) {
        if (statusCode < 100 || statusCode >= 600) {
            return "";
        }
        int statusCodeGroup = statusCode / 100;
        return String.format("%dxx", statusCodeGroup);
    }

    private String getPath() {
        return this.getResourceClassPath() + this.getResourceMethodPath();
    }

    private String getResourceClassPath() {
        Path classPath = this.resourceInfo.getResourceClass().getAnnotation(Path.class);
        return classPath != null ? classPath.value() : "";
    }

    private String getResourceMethodPath() {
        Path methodPath = this.resourceInfo.getResourceMethod().getAnnotation(Path.class);
        return methodPath != null ? methodPath.value() : "";
    }
}

