/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics.health.liveness;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.metrics.health.AbstractErrorCounterHealthCheck;
import io.apicurio.registry.metrics.health.liveness.LivenessCheck;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.slf4j.Logger;

@ApplicationScoped
@Liveness
@Default
public class ResponseErrorLivenessCheck
extends AbstractErrorCounterHealthCheck
implements HealthCheck,
LivenessCheck {
    @Inject
    Logger log;
    @ConfigProperty(name="apicurio.metrics.response-error-liveness-check.error-threshold", defaultValue="1")
    @Info(category="health", description="Error threshold of response liveness check", availableSince="1.0.2.Final")
    Integer configErrorThreshold;
    @ConfigProperty(name="apicurio.metrics.resonse-error-liveness-check.counter-reset-window-duration.seconds", defaultValue="60")
    @Info(category="health", description="Counter reset window duration of response liveness check", availableSince="1.0.2.Final")
    Integer configCounterResetWindowDurationSec;
    @ConfigProperty(name="apicurio.metrics.response-error-liveness-check.status-reset-window-duration.seconds", defaultValue="300")
    @Info(category="health", description="Status reset window duration of response liveness check", availableSince="1.0.2.Final")
    Integer configStatusResetWindowDurationSec;
    @ConfigProperty(name="apicurio.metrics.response-error-liveness-check.disabled", defaultValue="false")
    @Info(category="health", description="Disable logging of response liveness check", availableSince="2.0.0.Final")
    Boolean disableLogging;

    @PostConstruct
    void init() {
        this.init(this.configErrorThreshold, this.configCounterResetWindowDurationSec, this.configStatusResetWindowDurationSec);
    }

    public synchronized HealthCheckResponse call() {
        this.callSuper();
        return HealthCheckResponse.builder().name("ResponseErrorLivenessCheck").withData("errorCount", this.errorCounter).status(this.up).build();
    }

    @Override
    public void suspect(String reason) {
        if (this.disableLogging != Boolean.TRUE) {
            this.log.warn("Liveness problem suspected in ResponseErrorLivenessCheck: {}", (Object)reason);
        }
        super.suspectSuper();
        if (this.disableLogging != Boolean.TRUE) {
            this.log.info("After this event, the error counter is {} (out of the maximum {} allowed).", (Object)this.errorCounter, (Object)this.configErrorThreshold);
        }
    }

    @Override
    public void suspectWithException(Throwable reason) {
        if (this.disableLogging != Boolean.TRUE) {
            this.log.warn("Liveness problem suspected in ResponseErrorLivenessCheck because of an exception: ", reason);
        }
        super.suspectSuper();
        if (this.disableLogging != Boolean.TRUE) {
            this.log.info("After this event, the error counter is {} (out of the maximum {} allowed).", (Object)this.errorCounter, (Object)this.configErrorThreshold);
        }
    }
}

