/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics.health.readiness;

import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Readiness;
import org.slf4j.Logger;

@ApplicationScoped
@Readiness
@Default
public class PersistenceSimpleReadinessCheck
implements HealthCheck {
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;

    private boolean test() {
        try {
            return this.storage.isReady();
        }
        catch (Exception ex) {
            this.log.warn("Persistence is not ready:", (Throwable)ex);
            return false;
        }
    }

    public synchronized HealthCheckResponse call() {
        return HealthCheckResponse.builder().name("PersistenceSimpleReadinessCheck").status(this.test()).build();
    }
}

