/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics.health.readiness;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.metrics.health.AbstractErrorCounterHealthCheck;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.inject.Inject;
import java.time.Duration;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.slf4j.Logger;

@ApplicationScoped
@Liveness
@Default
public class PersistenceTimeoutReadinessCheck
extends AbstractErrorCounterHealthCheck
implements HealthCheck {
    @Inject
    Logger log;
    @ConfigProperty(name="apicurio.metrics.persistence-timeout-readiness-check.error-threshold", defaultValue="5")
    @Info(category="health", description="Error threshold of persistence readiness check", availableSince="1.0.2.Final")
    Integer configErrorThreshold;
    @ConfigProperty(name="apicurio.metrics.response-error-liveness-check.counter-reset-window-duration.seconds", defaultValue="60")
    @Info(category="health", description="Counter reset window duration of persistence readiness check", availableSince="1.0.2.Final")
    Integer configCounterResetWindowDurationSec;
    @ConfigProperty(name="apicurio.metrics.persitence-timeout-readiness-check.status-reset-window-duration.seconds", defaultValue="300")
    @Info(category="health", description="Status reset window duration of persistence readiness check", availableSince="1.0.2.Final")
    Integer configStatusResetWindowDurationSec;
    @ConfigProperty(name="apicurio.metrics.persistence-timeout-readiness-check.timeout.seconds", defaultValue="15")
    @Info(category="health", description="Timeout of persistence readiness check", availableSince="1.0.2.Final")
    Integer configTimeoutSec;
    private Duration timeoutSec;

    @PostConstruct
    void init() {
        this.init(this.configErrorThreshold, this.configCounterResetWindowDurationSec, this.configStatusResetWindowDurationSec);
        this.timeoutSec = Duration.ofSeconds(this.configTimeoutSec.intValue());
    }

    public synchronized HealthCheckResponse call() {
        this.callSuper();
        return HealthCheckResponse.builder().name("PersistenceTimeoutReadinessCheck").withData("errorCount", this.errorCounter).status(this.up).build();
    }

    public Duration getTimeoutSec() {
        return this.timeoutSec;
    }

    public void suspect() {
        this.suspectSuper();
    }
}

