/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics.health.readiness;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.metrics.health.AbstractErrorCounterHealthCheck;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Readiness;
import org.slf4j.Logger;

@ApplicationScoped
@Readiness
@Default
@Provider
public class ResponseTimeoutReadinessCheck
extends AbstractErrorCounterHealthCheck
implements HealthCheck,
ContainerRequestFilter,
ContainerResponseFilter {
    private static final String HEADER_NAME = "X-Apicurio-Registry-ResponseTimeoutReadinessCheck-RequestStart";
    @Inject
    Logger log;
    @ConfigProperty(name="apicurio.metrics.response-timeout-readiness-check.error-threshold", defaultValue="1")
    @Info(category="health", description="Error threshold of response readiness check", availableSince="1.0.2.Final")
    Instance<Integer> configErrorThreshold;
    @ConfigProperty(name="apicurio.metrics.response-timeout-readiness-check.counter-reset-window-duration.seconds", defaultValue="60")
    @Info(category="health", description="Counter reset window duration of response readiness check", availableSince="1.0.2.Final")
    Instance<Integer> configCounterResetWindowDurationSec;
    @ConfigProperty(name="apicurio.metrics.response-timeout-rediness-check.status-reset-window-duration.seconds", defaultValue="300")
    @Info(category="health", description="Status reset window duration of response readiness check", availableSince="1.0.2.Final")
    Instance<Integer> configStatusResetWindowDurationSec;
    @ConfigProperty(name="apicurio.metrics.response-timeout-readiness-check.timeout.seconds", defaultValue="10")
    @Info(category="health", description="Timeout of response readiness check", availableSince="1.0.2.Final")
    Instance<Integer> configTimeoutSec;
    private Duration timeoutSec;

    @PostConstruct
    void init() {
        this.init((Integer)this.configErrorThreshold.get(), (Integer)this.configCounterResetWindowDurationSec.get(), (Integer)this.configStatusResetWindowDurationSec.get());
        this.timeoutSec = Duration.ofSeconds(((Integer)this.configTimeoutSec.get()).intValue());
    }

    public void filter(ContainerRequestContext requestContext) {
        requestContext.getHeaders().putSingle((Object)HEADER_NAME, (Object)Instant.now().toString());
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String requestStart = requestContext.getHeaderString(HEADER_NAME);
        if (requestStart != null) {
            try {
                if (Instant.parse(requestStart).plus(this.timeoutSec).isBefore(Instant.now())) {
                    this.suspectSuper();
                }
            }
            catch (DateTimeParseException ex) {
                this.log.error("Value '{}' of header '{}' is the wrong format!", (Object)requestStart, (Object)HEADER_NAME);
            }
        } else if (responseContext.getStatus() != 404) {
            this.log.warn("Expected header '{}' not found.", (Object)HEADER_NAME);
        }
    }

    public synchronized HealthCheckResponse call() {
        this.callSuper();
        return HealthCheckResponse.builder().name("ResponseTimeoutReadinessCheck").withData("errorCount", this.errorCounter).status(this.up).build();
    }
}

