/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.services.DisabledApisMatcherService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApplicationScoped
public class RegistryApplicationServletFilter
implements Filter {
    @Inject
    DisabledApisMatcherService disabledApisMatcherService;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean disabled;
        HttpServletRequest req = (HttpServletRequest)request;
        String requestURI = req.getRequestURI();
        if (requestURI != null && (disabled = this.disabledApisMatcherService.isDisabled(requestURI))) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.reset();
            httpResponse.setStatus(404);
            return;
        }
        chain.doFilter(request, response);
    }
}

