/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.services.http.CCompatExceptionMapperService;
import io.apicurio.registry.services.http.CoreRegistryExceptionMapperService;
import io.apicurio.registry.services.http.CoreV2RegistryExceptionMapperService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@ApplicationScoped
@Provider
public class RegistryExceptionMapper
implements ExceptionMapper<Throwable> {
    @Inject
    CoreRegistryExceptionMapperService coreMapper;
    @Inject
    CoreV2RegistryExceptionMapperService coreV2Mapper;
    @Inject
    CCompatExceptionMapperService ccompatMapper;
    @Context
    HttpServletRequest request;

    public Response toResponse(Throwable t) {
        Response res = this.isCompatEndpoint() ? this.ccompatMapper.mapException(t) : (this.isV2Endpoint() ? this.coreV2Mapper.mapException(t) : this.coreMapper.mapException(t));
        return res;
    }

    private boolean isCompatEndpoint() {
        if (this.request != null) {
            return this.request.getRequestURI().contains("/apis/ccompat");
        }
        return false;
    }

    private boolean isV2Endpoint() {
        if (this.request != null) {
            return this.request.getRequestURI().contains("/apis/registry/v2");
        }
        return false;
    }
}

