/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import com.google.common.hash.Hashing;
import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.logging.audit.Audited;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.content.extract.ExtractedMetaData;
import io.apicurio.registry.content.util.ContentTypeUtil;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.model.BranchId;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.model.GAV;
import io.apicurio.registry.rest.HeadersHack;
import io.apicurio.registry.rest.MissingRequiredParameterException;
import io.apicurio.registry.rest.ParametersConflictException;
import io.apicurio.registry.rest.RestConfig;
import io.apicurio.registry.rest.v2.GroupsResource;
import io.apicurio.registry.rest.v2.V2ApiUtil;
import io.apicurio.registry.rest.v2.beans.ArtifactContent;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactOwner;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.Comment;
import io.apicurio.registry.rest.v2.beans.CreateGroupMetaData;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.GroupMetaData;
import io.apicurio.registry.rest.v2.beans.GroupSearchResults;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.NewComment;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.rest.v3.beans.ArtifactReference;
import io.apicurio.registry.rest.v3.beans.EditableVersionMetaData;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.storage.error.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.InvalidArtifactIdException;
import io.apicurio.registry.storage.error.InvalidGroupIdException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import io.apicurio.registry.storage.impl.sql.RegistryContentUtils;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.ReferenceType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.VersionState;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.util.ArtifactIdGenerator;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.utils.ArtifactIdValidator;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.JAXRSClientUtil;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jose4j.base64url.Base64;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class GroupsResourceImpl
implements GroupsResource {
    private static final String EMPTY_CONTENT_ERROR_MESSAGE = "Empty content is not allowed.";
    private static final Integer GET_GROUPS_LIMIT = 1000;
    @Inject
    RulesService rulesService;
    @Inject
    ArtifactIdGenerator idGenerator;
    @Inject
    RestConfig restConfig;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Inject
    io.apicurio.registry.rest.v3.GroupsResourceImpl v3;
    @Context
    HttpServletRequest request;

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Response getLatestArtifact(String groupId, String artifactId, Boolean dereference) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (dereference == null) {
            dereference = Boolean.FALSE;
        }
        try {
            GAV latestGAV = this.storage.getBranchTip(new GA(groupId, artifactId), BranchId.LATEST, RegistryStorage.RetrievalBehavior.SKIP_DISABLED_LATEST);
            ArtifactVersionMetaDataDto metaData = this.storage.getArtifactVersionMetaData(latestGAV.getRawGroupIdWithNull(), latestGAV.getRawArtifactId(), latestGAV.getRawVersionId());
            StoredArtifactVersionDto artifact = this.storage.getArtifactVersionContent(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, latestGAV.getRawVersionId());
            TypedContent contentToReturn = TypedContent.create((ContentHandle)artifact.getContent(), (String)artifact.getContentType());
            ArtifactTypeUtilProvider artifactTypeProvider = this.factory.getArtifactTypeProvider(metaData.getArtifactType());
            if (dereference.booleanValue() && !artifact.getReferences().isEmpty()) {
                if (artifactTypeProvider.supportsReferencesWithContext()) {
                    RegistryContentUtils.RewrittenContentHolder rewrittenContent = RegistryContentUtils.recursivelyResolveReferencesWithContext(contentToReturn, metaData.getArtifactType(), artifact.getReferences(), this.storage::getContentByReference);
                    contentToReturn = artifactTypeProvider.getContentDereferencer().dereference(rewrittenContent.getRewrittenContent(), rewrittenContent.getResolvedReferences());
                } else {
                    contentToReturn = artifactTypeProvider.getContentDereferencer().dereference(contentToReturn, RegistryContentUtils.recursivelyResolveReferences(artifact.getReferences(), this.storage::getContentByReference));
                }
            }
            Response.ResponseBuilder builder = Response.ok((Object)contentToReturn.getContent(), (String)contentToReturn.getContentType());
            this.checkIfDeprecated(metaData::getState, groupId, artifactId, metaData.getVersion(), builder);
            return builder.build();
        }
        catch (VersionNotFoundException e) {
            throw new ArtifactNotFoundException(e.getGroupId(), e.getArtifactId());
        }
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "name", "4", "name_encoded", "5", "description", "6", "description_encoded"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public ArtifactMetaData updateArtifact(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryNameEncoded, String xRegistryDescription, String xRegistryDescriptionEncoded, InputStream data) {
        return this.updateArtifactWithRefs(groupId, artifactId, xRegistryVersion, xRegistryName, xRegistryNameEncoded, xRegistryDescription, xRegistryDescriptionEncoded, data, Collections.emptyList());
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "name", "4", "name_encoded", "5", "description", "6", "description_encoded"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public ArtifactMetaData updateArtifact(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryNameEncoded, String xRegistryDescription, String xRegistryDescriptionEncoded, ArtifactContent data) {
        GroupsResourceImpl.requireParameter("content", data.getContent());
        return this.updateArtifactWithRefs(groupId, artifactId, xRegistryVersion, xRegistryName, xRegistryNameEncoded, xRegistryDescription, xRegistryDescriptionEncoded, IoUtil.toStream(data.getContent()), data.getReferences());
    }

    @Override
    public List<ArtifactReference> getArtifactVersionReferences(String groupId, String artifactId, String version, ReferenceType refType) {
        if (refType == null || refType == ReferenceType.OUTBOUND) {
            return this.storage.getArtifactVersionContent(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version).getReferences().stream().map(V2ApiUtil::referenceDtoToReference).collect(Collectors.toList());
        }
        return this.storage.getInboundArtifactReferences(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version).stream().map(V2ApiUtil::referenceDtoToReference).collect(Collectors.toList());
    }

    private ArtifactMetaData updateArtifactWithRefs(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryNameEncoded, String xRegistryDescription, String xRegistryDescriptionEncoded, InputStream data, List<ArtifactReference> references) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.maxOneOf("X-Registry-Name", xRegistryName, "X-Registry-Name-Encoded", xRegistryNameEncoded);
        GroupsResourceImpl.maxOneOf("X-Registry-Description", xRegistryDescription, "X-Registry-Description-Encoded", xRegistryDescriptionEncoded);
        String artifactName = GroupsResourceImpl.getOneOf(xRegistryName, GroupsResourceImpl.decode(xRegistryNameEncoded));
        String artifactDescription = GroupsResourceImpl.getOneOf(xRegistryDescription, GroupsResourceImpl.decode(xRegistryDescriptionEncoded));
        ContentHandle content = ContentHandle.create((InputStream)data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        return this.updateArtifactInternal(groupId, artifactId, xRegistryVersion, artifactName, artifactDescription, content, this.getContentType(), references);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifact(String groupId, String artifactId) {
        if (!this.restConfig.isArtifactDeletionEnabled()) {
            throw new NotAllowedException("Artifact deletion operation is not enabled.", "GET", (String[])null);
        }
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        this.storage.deleteArtifact(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public ArtifactMetaData getArtifactMetaData(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
        GAV latestGAV = this.storage.getBranchTip(new GA(groupId, artifactId), BranchId.LATEST, RegistryStorage.RetrievalBehavior.SKIP_DISABLED_LATEST);
        ArtifactVersionMetaDataDto vdto = this.storage.getArtifactVersionMetaData(latestGAV.getRawGroupIdWithNull(), latestGAV.getRawArtifactId(), latestGAV.getRawVersionId());
        ArtifactMetaData amd = V2ApiUtil.dtoToMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, dto.getArtifactType(), dto);
        amd.setContentId(vdto.getContentId());
        amd.setGlobalId(vdto.getGlobalId());
        amd.setVersion(vdto.getVersion());
        amd.setName(vdto.getName());
        amd.setDescription(vdto.getDescription());
        amd.setModifiedBy(vdto.getOwner());
        amd.setModifiedOn(new Date(vdto.getCreatedOn()));
        amd.setLabels(V2ApiUtil.toV2Labels(vdto.getLabels()));
        amd.setProperties(V2ApiUtil.toV2Properties(vdto.getLabels()));
        amd.setState(ArtifactState.fromValue(vdto.getState().name()));
        return amd;
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "editable_metadata"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactMetaData(String groupId, String artifactId, EditableMetaData data) {
        GAV latestGAV = this.storage.getBranchTip(new GA(groupId, artifactId), BranchId.LATEST, RegistryStorage.RetrievalBehavior.DEFAULT);
        this.storage.updateArtifactVersionMetaData(groupId, artifactId, latestGAV.getRawVersionId(), EditableVersionMetaDataDto.builder().name(data.getName()).description(data.getDescription()).labels(V2ApiUtil.toV3Labels(data.getLabels(), data.getProperties())).build());
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public ArtifactOwner getArtifactOwner(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
        ArtifactOwner owner = new ArtifactOwner();
        owner.setOwner(dto.getOwner());
        return owner;
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "owner"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.AdminOrOwner)
    public void updateArtifactOwner(String groupId, String artifactId, ArtifactOwner data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("data", data);
        if (data.getOwner().isEmpty()) {
            throw new MissingRequiredParameterException("Missing required owner");
        }
        EditableArtifactMetaDataDto emd = EditableArtifactMetaDataDto.builder().owner(data.getOwner()).build();
        this.storage.updateArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, emd);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public GroupMetaData getGroupById(String groupId) {
        GroupMetaDataDto group = this.storage.getGroupMetaData(groupId);
        return V2ApiUtil.groupDtoToGroup(group);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public void deleteGroupById(String groupId) {
        if (!this.restConfig.isGroupDeletionEnabled()) {
            throw new NotAllowedException("Group deletion operation is not enabled.", "GET", (String[])null);
        }
        this.storage.deleteGroup(groupId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public GroupSearchResults listGroups(BigInteger limit, BigInteger offset, SortOrder order, SortBy orderby) {
        if (orderby == null) {
            orderby = SortBy.name;
        }
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        Set<SearchFilter> filters = Collections.emptySet();
        GroupSearchResultsDto resultsDto = this.storage.searchGroups(filters, oBy, oDir, offset.intValue(), limit.intValue());
        return V2ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Write)
    public GroupMetaData createGroup(CreateGroupMetaData data) {
        GroupMetaDataDto.GroupMetaDataDtoBuilder group = GroupMetaDataDto.builder().groupId(data.getId()).description(data.getDescription()).labels(data.getProperties());
        String user = this.securityIdentity.getPrincipal().getName();
        group.owner(user).createdOn(new Date().getTime());
        this.storage.createGroup(group.build());
        return V2ApiUtil.groupDtoToGroup(this.storage.getGroupMetaData(data.getId()));
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, ArtifactContent artifactContent) {
        return this.getArtifactVersionMetaDataByContent(groupId, artifactId, canonical, IoUtil.toStream(artifactContent.getContent()), artifactContent.getReferences());
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, InputStream data) {
        return this.getArtifactVersionMetaDataByContent(groupId, artifactId, canonical, data, Collections.emptyList());
    }

    private VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, InputStream data, List<ArtifactReference> artifactReferences) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (canonical == null) {
            canonical = Boolean.FALSE;
        }
        String contentType = this.getContentType();
        ContentHandle content = ContentHandle.create((InputStream)data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        if (ContentTypeUtil.isApplicationYaml((String)this.getContentType())) {
            content = ContentTypeUtil.yamlToJson((ContentHandle)content);
            contentType = "application/json";
        }
        List<ArtifactReferenceDto> artifactReferenceDtos = this.toReferenceDtos(artifactReferences);
        TypedContent typedContent = TypedContent.create((ContentHandle)content, (String)contentType);
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaDataByContent(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, canonical, typedContent, artifactReferenceDtos);
        return V2ApiUtil.dtoToVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, dto.getArtifactType(), dto);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public List<RuleType> listArtifactRules(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        return this.storage.getArtifactRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "rule"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void createArtifactRule(String groupId, String artifactId, Rule data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        RuleType type = data.getType();
        GroupsResourceImpl.requireParameter("type", (Object)type);
        if (data.getConfig() == null || data.getConfig().isEmpty()) {
            throw new MissingRequiredParameterException("Config");
        }
        RuleConfigurationDto config = new RuleConfigurationDto();
        config.setConfiguration(data.getConfig());
        if (!this.storage.isArtifactExists(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId)) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        this.storage.createArtifactRule(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, data.getType(), config);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactRules(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        this.storage.deleteArtifactRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Rule getArtifactRuleConfig(String groupId, String artifactId, RuleType rule) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("rule", (Object)rule);
        RuleConfigurationDto dto = this.storage.getArtifactRule(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, rule);
        Rule rval = new Rule();
        rval.setConfig(dto.getConfiguration());
        rval.setType(rule);
        return rval;
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "rule_type", "3", "rule"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public Rule updateArtifactRuleConfig(String groupId, String artifactId, RuleType rule, Rule data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("rule", (Object)rule);
        RuleConfigurationDto dto = new RuleConfigurationDto(data.getConfig());
        this.storage.updateArtifactRule(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, rule, dto);
        Rule rval = new Rule();
        rval.setType(rule);
        rval.setConfig(data.getConfig());
        return rval;
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "rule_type"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("rule", (Object)rule);
        this.storage.deleteArtifactRule(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, rule);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "update_state"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactState(String groupId, String artifactId, UpdateState data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("body.state", (Object)data.getState());
        GAV latestGAV = this.storage.getBranchTip(new GA(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId), BranchId.LATEST, RegistryStorage.RetrievalBehavior.DEFAULT);
        this.updateArtifactVersionState(groupId, artifactId, latestGAV.getRawVersionId(), data);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void testUpdateArtifact(String groupId, String artifactId, InputStream data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        ContentHandle content = ContentHandle.create((InputStream)data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        if (ContentTypeUtil.isApplicationYaml((String)ct)) {
            content = ContentTypeUtil.yamlToJson((ContentHandle)content);
            ct = "application/json";
        }
        String artifactType = this.lookupArtifactType(groupId, artifactId);
        TypedContent typedContent = TypedContent.create((ContentHandle)content, (String)ct);
        this.rulesService.applyRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, typedContent, RuleApplicationType.UPDATE, Collections.emptyList(), Collections.emptyMap());
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Response getArtifactVersion(String groupId, String artifactId, String version, Boolean dereference) {
        ArtifactVersionMetaDataDto metaData;
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        if (dereference == null) {
            dereference = Boolean.FALSE;
        }
        if (VersionState.DISABLED.equals((Object)(metaData = this.storage.getArtifactVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version)).getState())) {
            throw new VersionNotFoundException(groupId, artifactId, version);
        }
        StoredArtifactVersionDto artifact = this.storage.getArtifactVersionContent(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version);
        TypedContent contentToReturn = TypedContent.create((ContentHandle)artifact.getContent(), (String)artifact.getContentType());
        ArtifactTypeUtilProvider artifactTypeProvider = this.factory.getArtifactTypeProvider(metaData.getArtifactType());
        if (dereference.booleanValue() && !artifact.getReferences().isEmpty()) {
            if (artifactTypeProvider.supportsReferencesWithContext()) {
                RegistryContentUtils.RewrittenContentHolder rewrittenContent = RegistryContentUtils.recursivelyResolveReferencesWithContext(contentToReturn, metaData.getArtifactType(), artifact.getReferences(), this.storage::getContentByReference);
                contentToReturn = artifactTypeProvider.getContentDereferencer().dereference(rewrittenContent.getRewrittenContent(), rewrittenContent.getResolvedReferences());
            } else {
                contentToReturn = artifactTypeProvider.getContentDereferencer().dereference(contentToReturn, RegistryContentUtils.recursivelyResolveReferences(artifact.getReferences(), this.storage::getContentByReference));
            }
        }
        Response.ResponseBuilder builder = Response.ok((Object)contentToReturn.getContent(), (String)contentToReturn.getContentType());
        this.checkIfDeprecated(metaData::getState, groupId, artifactId, version, builder);
        return builder.build();
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactVersion(String groupId, String artifactId, String version) {
        if (!this.restConfig.isArtifactVersionDeletionEnabled()) {
            throw new NotAllowedException("Artifact version deletion operation is not enabled.", "GET", (String[])null);
        }
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        this.storage.deleteArtifactVersion(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaData(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version);
        return V2ApiUtil.dtoToVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, dto.getArtifactType(), dto);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "editable_metadata"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableMetaData data) {
        this.v3.updateArtifactVersionMetaData(groupId, artifactId, version, (EditableVersionMetaData)((EditableVersionMetaData.EditableVersionMetaDataBuilder)((EditableVersionMetaData.EditableVersionMetaDataBuilder)((EditableVersionMetaData.EditableVersionMetaDataBuilder)EditableVersionMetaData.builder().description(data.getDescription())).labels(V2ApiUtil.toV3Labels(data.getLabels(), data.getProperties()))).name(data.getName())).build());
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactVersionMetaData(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        EditableVersionMetaDataDto vmd = EditableVersionMetaDataDto.builder().name("").description("").labels(Map.of()).build();
        this.storage.updateArtifactVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, vmd);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public Comment addArtifactVersionComment(String groupId, String artifactId, String version, NewComment data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        CommentDto newComment = this.storage.createArtifactVersionComment(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, data.getValue());
        return V2ApiUtil.commentDtoToComment(newComment);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "comment_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactVersionComment(String groupId, String artifactId, String version, String commentId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        GroupsResourceImpl.requireParameter("commentId", commentId);
        this.storage.deleteArtifactVersionComment(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, commentId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public List<Comment> getArtifactVersionComments(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        return this.storage.getArtifactVersionComments(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version).stream().map(V2ApiUtil::commentDtoToComment).collect(Collectors.toList());
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "comment_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactVersionComment(String groupId, String artifactId, String version, String commentId, NewComment data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        GroupsResourceImpl.requireParameter("commentId", commentId);
        GroupsResourceImpl.requireParameter("value", data.getValue());
        this.storage.updateArtifactVersionComment(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, commentId, data.getValue());
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "update_state"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactVersionState(String groupId, String artifactId, String version, UpdateState data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        EditableVersionMetaDataDto emd = EditableVersionMetaDataDto.builder().state(VersionState.fromValue(data.getState().name())).build();
        this.storage.updateArtifactVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, emd);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Read)
    public ArtifactSearchResults listArtifactsInGroup(String groupId, BigInteger limit, BigInteger offset, SortOrder order, SortBy orderby) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        if (orderby == null) {
            orderby = SortBy.name;
        }
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        filters.add(SearchFilter.ofGroupId(V2ApiUtil.defaultGroupIdToNull(groupId)));
        ArtifactSearchResultsDto resultsDto = this.storage.searchArtifacts(filters, oBy, oDir, offset.intValue(), limit.intValue());
        return V2ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Override
    @Audited(extractParameters={"0", "group_id"})
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public void deleteArtifactsInGroup(String groupId) {
        if (!this.restConfig.isArtifactDeletionEnabled()) {
            throw new NotAllowedException("Artifact deletion operation is not enabled.", "GET", (String[])null);
        }
        GroupsResourceImpl.requireParameter("groupId", groupId);
        this.storage.deleteArtifacts(V2ApiUtil.defaultGroupIdToNull(groupId));
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_type", "2", "artifact_id", "3", "version", "4", "if_exists", "5", "canonical", "6", "description", "7", "description_encoded", "8", "name", "9", "name_encoded", "10", "from_url", "11", "artifact_sha"})
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public ArtifactMetaData createArtifact(String groupId, String xRegistryArtifactType, String xRegistryArtifactId, String xRegistryVersion, IfExists ifExists, Boolean canonical, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryName, String xRegistryNameEncoded, String xRegistryContentHash, String xRegistryHashAlgorithm, InputStream data) {
        return this.createArtifactWithRefs(groupId, xRegistryArtifactType, xRegistryArtifactId, xRegistryVersion, ifExists, canonical, xRegistryDescription, xRegistryDescriptionEncoded, xRegistryName, xRegistryNameEncoded, xRegistryContentHash, xRegistryHashAlgorithm, data, Collections.emptyList());
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_type", "2", "artifact_id", "3", "version", "4", "if_exists", "5", "canonical", "6", "description", "7", "description_encoded", "8", "name", "9", "name_encoded", "10", "from_url", "11", "artifact_sha"})
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public ArtifactMetaData createArtifact(String groupId, String xRegistryArtifactType, String xRegistryArtifactId, String xRegistryVersion, IfExists ifExists, Boolean canonical, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryName, String xRegistryNameEncoded, String xRegistryContentHash, String xRegistryHashAlgorithm, ArtifactContent data) {
        GroupsResourceImpl.requireParameter("content", data.getContent());
        try (Client client = null;){
            InputStream content;
            try {
                URL url = new URL(data.getContent());
                client = JAXRSClientUtil.getJAXRSClient(this.restConfig.getDownloadSkipSSLValidation());
                content = this.fetchContentFromURL(client, url.toURI());
            }
            catch (MalformedURLException | URISyntaxException e) {
                content = IoUtil.toStream(data.getContent());
            }
            ArtifactMetaData e = this.createArtifactWithRefs(groupId, xRegistryArtifactType, xRegistryArtifactId, xRegistryVersion, ifExists, canonical, xRegistryDescription, xRegistryDescriptionEncoded, xRegistryName, xRegistryNameEncoded, xRegistryContentHash, xRegistryHashAlgorithm, content, data.getReferences());
            return e;
        }
    }

    private InputStream fetchContentFromURL(Client client, URI url) {
        try {
            List contentLengthHeaders = (List)client.target(url).request().head().getHeaders().get((Object)"Content-Length");
            if (contentLengthHeaders == null || contentLengthHeaders.size() < 1) {
                throw new BadRequestException("Requested resource URL does not provide 'Content-Length' in the headers");
            }
            int contentLength = Integer.parseInt(contentLengthHeaders.get(0).toString());
            if (contentLength > this.restConfig.getDownloadMaxSize()) {
                throw new BadRequestException("Requested resource is bigger than " + this.restConfig.getDownloadMaxSize() + " and cannot be downloaded.");
            }
            if (contentLength <= 0) {
                throw new BadRequestException("Requested resource URL is providing 'Content-Length' <= 0.");
            }
            return new BufferedInputStream((InputStream)client.target(url).request().get().readEntity(InputStream.class), contentLength);
        }
        catch (BadRequestException bre) {
            throw bre;
        }
        catch (Exception e) {
            throw new BadRequestException("Errors downloading the artifact content.", (Throwable)e);
        }
    }

    private ArtifactMetaData createArtifactWithRefs(String groupId, String xRegistryArtifactType, String xRegistryArtifactId, String xRegistryVersion, IfExists ifExists, Boolean canonical, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryName, String xRegistryNameEncoded, String xRegistryContentHash, String xRegistryHashAlgorithm, InputStream data, List<ArtifactReference> references) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.maxOneOf("X-Registry-Name", xRegistryName, "X-Registry-Name-Encoded", xRegistryNameEncoded);
        GroupsResourceImpl.maxOneOf("X-Registry-Description", xRegistryDescription, "X-Registry-Description-Encoded", xRegistryDescriptionEncoded);
        String artifactName = GroupsResourceImpl.getOneOf(xRegistryName, GroupsResourceImpl.decode(xRegistryNameEncoded));
        String artifactDescription = GroupsResourceImpl.getOneOf(xRegistryDescription, GroupsResourceImpl.decode(xRegistryDescriptionEncoded));
        if (!ArtifactIdValidator.isGroupIdAllowed(groupId)) {
            throw new InvalidGroupIdException("Character % and non ASCII characters are not allowed in group IDs.");
        }
        ContentHandle content = ContentHandle.create((InputStream)data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        if (xRegistryContentHash != null) {
            String calculatedSha = null;
            try {
                RegistryHashAlgorithm algorithm = xRegistryHashAlgorithm == null ? RegistryHashAlgorithm.SHA256 : RegistryHashAlgorithm.valueOf(xRegistryHashAlgorithm);
                switch (algorithm) {
                    case MD5: {
                        calculatedSha = Hashing.md5().hashString((CharSequence)content.content(), StandardCharsets.UTF_8).toString();
                        break;
                    }
                    case SHA256: {
                        calculatedSha = Hashing.sha256().hashString((CharSequence)content.content(), StandardCharsets.UTF_8).toString();
                    }
                }
            }
            catch (Exception e) {
                throw new BadRequestException("Requested hash algorithm not supported");
            }
            if (!calculatedSha.equals(xRegistryContentHash.trim())) {
                throw new BadRequestException("Provided Artifact Hash doesn't match with the content");
            }
        }
        boolean fcanonical = canonical == null ? Boolean.FALSE : canonical;
        String ct = this.getContentType();
        try {
            String artifactId = xRegistryArtifactId;
            if (artifactId == null || artifactId.trim().isEmpty()) {
                artifactId = this.idGenerator.generate();
            } else if (!ArtifactIdValidator.isArtifactIdAllowed(artifactId)) {
                throw new InvalidArtifactIdException("Character % and non ASCII characters are not allowed in artifact IDs.");
            }
            if (ContentTypeUtil.isApplicationYaml((String)ct) || ContentTypeUtil.isApplicationCreateExtended((String)ct) && ContentTypeUtil.isParsableYaml((ContentHandle)content)) {
                content = ContentTypeUtil.yamlToJson((ContentHandle)content);
                ct = "application/json";
            }
            TypedContent typedContent = TypedContent.create((ContentHandle)content, (String)ct);
            String artifactType = ArtifactTypeUtil.determineArtifactType(typedContent, xRegistryArtifactType, this.factory);
            List<ArtifactReferenceDto> referencesAsDtos = this.toReferenceDtos(references);
            Map<String, TypedContent> resolvedReferences = RegistryContentUtils.recursivelyResolveReferences(referencesAsDtos, this.storage::getContentByReference);
            this.rulesService.applyRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, typedContent, RuleApplicationType.CREATE, GroupsResourceImpl.toV3Refs(references), resolvedReferences);
            EditableArtifactMetaDataDto metaData = this.extractMetaData(artifactType, content);
            if (artifactName != null && artifactName.trim().isEmpty()) {
                metaData.setName(artifactName);
            }
            if (artifactDescription != null && artifactDescription.trim().isEmpty()) {
                metaData.setDescription(artifactDescription);
            }
            ContentWrapperDto contentDto = ContentWrapperDto.builder().contentType(ct).content(content).references(referencesAsDtos).build();
            EditableVersionMetaDataDto versionMetaData = EditableVersionMetaDataDto.builder().name(metaData.getName()).description(metaData.getDescription()).labels(Map.of()).build();
            Pair<ArtifactMetaDataDto, ArtifactVersionMetaDataDto> createResult = this.storage.createArtifact(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, metaData, xRegistryVersion, contentDto, versionMetaData, List.of(), false);
            return V2ApiUtil.dtoToMetaData(groupId, artifactId, artifactType, (ArtifactVersionMetaDataDto)createResult.getRight());
        }
        catch (ArtifactAlreadyExistsException ex) {
            return this.handleIfExists(groupId, xRegistryArtifactId, xRegistryVersion, ifExists, artifactName, artifactDescription, content, ct, fcanonical, references);
        }
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionSearchResults listArtifactVersions(String groupId, String artifactId, BigInteger offset, BigInteger limit) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        this.storage.getArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        Set<SearchFilter> filters = Set.of(SearchFilter.ofGroupId(V2ApiUtil.defaultGroupIdToNull(groupId)), SearchFilter.ofArtifactId(artifactId));
        VersionSearchResultsDto resultsDto = this.storage.searchVersions(filters, OrderBy.createdOn, OrderDirection.asc, offset.intValue(), limit.intValue());
        return V2ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "name", "4", "description", "5", "description_encoded", "6", "name_encoded"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public VersionMetaData createArtifactVersion(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryNameEncoded, InputStream data) {
        return this.createArtifactVersionWithRefs(groupId, artifactId, xRegistryVersion, xRegistryName, xRegistryDescription, xRegistryDescriptionEncoded, xRegistryNameEncoded, data, Collections.emptyList());
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "name", "4", "description", "5", "description_encoded", "6", "name_encoded"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public VersionMetaData createArtifactVersion(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryNameEncoded, ArtifactContent data) {
        GroupsResourceImpl.requireParameter("content", data.getContent());
        return this.createArtifactVersionWithRefs(groupId, artifactId, xRegistryVersion, xRegistryName, xRegistryDescription, xRegistryDescriptionEncoded, xRegistryNameEncoded, IoUtil.toStream(data.getContent()), data.getReferences());
    }

    private VersionMetaData createArtifactVersionWithRefs(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryNameEncoded, InputStream data, List<ArtifactReference> references) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.maxOneOf("X-Registry-Name", xRegistryName, "X-Registry-Name-Encoded", xRegistryNameEncoded);
        GroupsResourceImpl.maxOneOf("X-Registry-Description", xRegistryDescription, "X-Registry-Description-Encoded", xRegistryDescriptionEncoded);
        String artifactName = GroupsResourceImpl.getOneOf(xRegistryName, GroupsResourceImpl.decode(xRegistryNameEncoded));
        String artifactDescription = GroupsResourceImpl.getOneOf(xRegistryDescription, GroupsResourceImpl.decode(xRegistryDescriptionEncoded));
        ContentHandle content = ContentHandle.create((InputStream)data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        if (ContentTypeUtil.isApplicationYaml((String)ct)) {
            content = ContentTypeUtil.yamlToJson((ContentHandle)content);
            ct = "application/json";
        }
        List<ArtifactReferenceDto> referencesAsDtos = this.toReferenceDtos(references);
        Map<String, TypedContent> resolvedReferences = RegistryContentUtils.recursivelyResolveReferences(referencesAsDtos, this.storage::getContentByReference);
        String artifactType = this.lookupArtifactType(groupId, artifactId);
        TypedContent typedContent = TypedContent.create((ContentHandle)content, (String)ct);
        this.rulesService.applyRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, typedContent, RuleApplicationType.UPDATE, GroupsResourceImpl.toV3Refs(references), resolvedReferences);
        EditableVersionMetaDataDto metaData = this.getEditableVersionMetaData(artifactName, artifactDescription);
        ContentWrapperDto contentDto = ContentWrapperDto.builder().content(content).contentType(ct).references(referencesAsDtos).build();
        ArtifactVersionMetaDataDto vmdDto = this.storage.createArtifactVersion(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, xRegistryVersion, artifactType, contentDto, metaData, List.of(), false);
        return V2ApiUtil.dtoToVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, vmdDto);
    }

    private void checkIfDeprecated(Supplier<VersionState> stateSupplier, String groupId, String artifactId, String version, Response.ResponseBuilder builder) {
        HeadersHack.checkIfDeprecated(stateSupplier, groupId, artifactId, version, builder);
    }

    private String lookupArtifactType(String groupId, String artifactId) {
        return this.storage.getArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId).getArtifactType();
    }

    private String getContentType() {
        return this.request.getContentType();
    }

    private static final void requireParameter(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            throw new MissingRequiredParameterException(parameterName);
        }
    }

    private static void maxOneOf(String parameterOneName, Object parameterOneValue, String parameterTwoName, Object parameterTwoValue) {
        if (parameterOneValue != null && parameterTwoValue != null) {
            throw new ParametersConflictException(parameterOneName, parameterTwoName);
        }
    }

    private static <T> T getOneOf(T parameterOneValue, T parameterTwoValue) {
        return parameterOneValue != null ? parameterOneValue : parameterTwoValue;
    }

    private static String decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        return new String(Base64.decode((String)encoded));
    }

    private ArtifactMetaData handleIfExists(String groupId, String artifactId, String version, IfExists ifExists, String artifactName, String artifactDescription, ContentHandle content, String contentType, boolean canonical, List<ArtifactReference> references) {
        ArtifactMetaData artifactMetaData = this.getArtifactMetaData(groupId, artifactId);
        if (ifExists == null) {
            ifExists = IfExists.FAIL;
        }
        switch (ifExists) {
            case UPDATE: {
                return this.updateArtifactInternal(groupId, artifactId, version, artifactName, artifactDescription, content, contentType, references);
            }
            case RETURN: {
                return artifactMetaData;
            }
            case RETURN_OR_UPDATE: {
                return this.handleIfExistsReturnOrUpdate(groupId, artifactId, version, artifactName, artifactDescription, content, contentType, canonical, references);
            }
        }
        throw new ArtifactAlreadyExistsException(groupId, artifactId);
    }

    private ArtifactMetaData handleIfExistsReturnOrUpdate(String groupId, String artifactId, String version, String artifactName, String artifactDescription, ContentHandle content, String contentType, boolean canonical, List<ArtifactReference> references) {
        try {
            TypedContent typedContent = TypedContent.create((ContentHandle)content, (String)contentType);
            ArtifactVersionMetaDataDto mdDto = this.storage.getArtifactVersionMetaDataByContent(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, canonical, typedContent, this.toReferenceDtos(references));
            ArtifactMetaData md = V2ApiUtil.dtoToMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, null, mdDto);
            return md;
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            return this.updateArtifactInternal(groupId, artifactId, version, artifactName, artifactDescription, content, contentType, references);
        }
    }

    private ArtifactMetaData updateArtifactInternal(String groupId, String artifactId, String version, String name, String description, ContentHandle content, String contentType, List<ArtifactReference> references) {
        if (ContentTypeUtil.isApplicationYaml((String)contentType)) {
            content = ContentTypeUtil.yamlToJson((ContentHandle)content);
            contentType = "application/json";
        }
        String artifactType = this.lookupArtifactType(groupId, artifactId);
        List<ArtifactReferenceDto> referencesAsDtos = this.toReferenceDtos(references);
        Map<String, TypedContent> resolvedReferences = RegistryContentUtils.recursivelyResolveReferences(referencesAsDtos, this.storage::getContentByReference);
        TypedContent typedContent = TypedContent.create((ContentHandle)content, (String)contentType);
        this.rulesService.applyRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, typedContent, RuleApplicationType.UPDATE, GroupsResourceImpl.toV3Refs(references), resolvedReferences);
        EditableArtifactMetaDataDto artifactMD = this.extractMetaData(artifactType, content);
        if (name != null && name.trim().isEmpty()) {
            artifactMD.setName(name);
        }
        if (description != null && description.trim().isEmpty()) {
            artifactMD.setDescription(description);
        }
        EditableVersionMetaDataDto metaData = EditableVersionMetaDataDto.builder().name(artifactMD.getName()).description(artifactMD.getDescription()).labels(artifactMD.getLabels()).build();
        ContentWrapperDto contentDto = ContentWrapperDto.builder().content(content).contentType(contentType).references(referencesAsDtos).build();
        ArtifactVersionMetaDataDto dto = this.storage.createArtifactVersion(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, artifactType, contentDto, metaData, List.of(), false);
        this.storage.updateArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactMD);
        return V2ApiUtil.dtoToMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, dto);
    }

    private EditableArtifactMetaDataDto getEditableArtifactMetaData(String name, String description) {
        if (name != null || description != null) {
            return EditableArtifactMetaDataDto.builder().name(name).description(description).build();
        }
        return null;
    }

    private EditableVersionMetaDataDto getEditableVersionMetaData(String name, String description) {
        if (name != null || description != null) {
            return EditableVersionMetaDataDto.builder().name(name).description(description).build();
        }
        return null;
    }

    private List<ArtifactReferenceDto> toReferenceDtos(List<ArtifactReference> references) {
        if (references == null) {
            references = Collections.emptyList();
        }
        return references.stream().map(r -> {
            r.setGroupId(V2ApiUtil.defaultGroupIdToNull(r.getGroupId()));
            return r;
        }).map(V2ApiUtil::referenceToDto).collect(Collectors.toList());
    }

    private static List<io.apicurio.registry.rest.v3.beans.ArtifactReference> toV3Refs(List<ArtifactReference> references) {
        return references.stream().map(ref -> GroupsResourceImpl.toV3Ref(ref)).collect(Collectors.toList());
    }

    private static io.apicurio.registry.rest.v3.beans.ArtifactReference toV3Ref(ArtifactReference reference) {
        return ((ArtifactReference.ArtifactReferenceBuilder)((ArtifactReference.ArtifactReferenceBuilder)((ArtifactReference.ArtifactReferenceBuilder)((ArtifactReference.ArtifactReferenceBuilder)io.apicurio.registry.rest.v3.beans.ArtifactReference.builder().artifactId(reference.getArtifactId())).groupId(reference.getGroupId())).version(reference.getVersion())).name(reference.getName())).build();
    }

    protected EditableArtifactMetaDataDto extractMetaData(String artifactType, ContentHandle content) {
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(artifactType);
        ContentExtractor extractor = provider.getContentExtractor();
        ExtractedMetaData emd = extractor.extract(content);
        EditableArtifactMetaDataDto metaData = emd != null ? new EditableArtifactMetaDataDto(emd.getName(), emd.getDescription(), null, emd.getLabels()) : new EditableArtifactMetaDataDto();
        return metaData;
    }

    public static enum RegistryHashAlgorithm {
        SHA256,
        MD5;

    }
}

