/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v3;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.dereference.ContentDereferencer;
import io.apicurio.registry.content.refs.JsonPointerExternalReference;
import io.apicurio.registry.rest.v3.beans.HandleReferencesType;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.impl.sql.RegistryContentUtils;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.utils.StringUtil;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Context;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

public abstract class AbstractResourceImpl {
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Context
    HttpServletRequest request;
    @ConfigProperty(name="apicurio.apis.v3.base-href", defaultValue="_")
    @Info(category="api", description="API base href (URI)", availableSince="2.5.0.Final")
    String apiBaseHref;

    protected TypedContent handleContentReferences(HandleReferencesType referencesType, String artifactType, TypedContent content, List<ArtifactReferenceDto> references) {
        if (!references.isEmpty()) {
            if (referencesType == HandleReferencesType.DEREFERENCE) {
                ArtifactTypeUtilProvider artifactTypeProvider = this.factory.getArtifactTypeProvider(artifactType);
                if (artifactTypeProvider.supportsReferencesWithContext()) {
                    RegistryContentUtils.RewrittenContentHolder rewrittenContent = RegistryContentUtils.recursivelyResolveReferencesWithContext(content, artifactType, references, this.storage::getContentByReference);
                    content = artifactTypeProvider.getContentDereferencer().dereference(rewrittenContent.getRewrittenContent(), rewrittenContent.getResolvedReferences());
                } else {
                    content = artifactTypeProvider.getContentDereferencer().dereference(content, RegistryContentUtils.recursivelyResolveReferences(references, this.storage::getContentByReference));
                }
            } else if (referencesType == HandleReferencesType.REWRITE) {
                ArtifactTypeUtilProvider artifactTypeProvider = this.factory.getArtifactTypeProvider(artifactType);
                ContentDereferencer contentDereferencer = artifactTypeProvider.getContentDereferencer();
                Map<String, String> resolvedReferenceUrls = this.resolveReferenceUrls(references);
                content = contentDereferencer.rewriteReferences(content, resolvedReferenceUrls);
            }
        }
        return content;
    }

    protected Map<String, String> resolveReferenceUrls(List<ArtifactReferenceDto> references) {
        HashMap<String, String> rval = new HashMap<String, String>();
        for (ArtifactReferenceDto reference : references) {
            Object resolvedReferenceUrl = this.resolveReferenceUrl(reference);
            if (reference.getName().contains("#")) {
                JsonPointerExternalReference jpRef = new JsonPointerExternalReference(reference.getName());
                resolvedReferenceUrl = (String)resolvedReferenceUrl + jpRef.getComponent();
            }
            if (resolvedReferenceUrl == null) continue;
            rval.put(reference.getName(), (String)resolvedReferenceUrl);
        }
        return rval;
    }

    protected String resolveReferenceUrl(ArtifactReferenceDto reference) {
        URI baseHref = null;
        try {
            if (!"_".equals(this.apiBaseHref)) {
                baseHref = new URI(this.apiBaseHref);
            } else {
                baseHref = AbstractResourceImpl.getApiBaseHrefFromXForwarded(this.request);
                if (baseHref == null) {
                    baseHref = AbstractResourceImpl.getApiBaseHrefFromRequest(this.request);
                }
            }
        }
        catch (URISyntaxException e) {
            this.log.error("Error trying to determine the baseHref of the REST API.", (Throwable)e);
            return null;
        }
        if (baseHref == null) {
            this.log.warn("Failed to determine baseHref for the REST API.");
            return null;
        }
        String path = String.format("/apis/registry/v3/groups/%s/artifacts/%s/versions/%s?references=REWRITE", URLEncoder.encode(reference.getGroupId(), StandardCharsets.UTF_8), URLEncoder.encode(reference.getArtifactId(), StandardCharsets.UTF_8), URLEncoder.encode(reference.getVersion(), StandardCharsets.UTF_8));
        return baseHref.resolve(path).toString();
    }

    private static URI getApiBaseHrefFromXForwarded(HttpServletRequest request) throws URISyntaxException {
        String fproto = request.getHeader("X-Forwarded-Proto");
        String fhost = request.getHeader("X-Forwarded-Host");
        if (!StringUtil.isEmpty(fproto) && !StringUtil.isEmpty(fhost)) {
            return new URI(fproto + "://" + fhost);
        }
        return null;
    }

    private static URI getApiBaseHrefFromRequest(HttpServletRequest request) throws URISyntaxException {
        String requestUrl = request.getRequestURL().toString();
        URI requestUri = new URI(requestUrl);
        return requestUri.resolve("/");
    }
}

