/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v3;

import io.apicurio.common.apps.config.Dynamic;
import io.apicurio.common.apps.config.DynamicConfigPropertyDef;
import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.DynamicConfigPropertyIndex;
import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.logging.audit.Audited;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.auth.RoleBasedAccessApiOperation;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.ConflictException;
import io.apicurio.registry.rest.MissingRequiredParameterException;
import io.apicurio.registry.rest.v3.AdminResource;
import io.apicurio.registry.rest.v3.V3ApiUtil;
import io.apicurio.registry.rest.v3.beans.ArtifactTypeInfo;
import io.apicurio.registry.rest.v3.beans.ConfigurationProperty;
import io.apicurio.registry.rest.v3.beans.CreateRule;
import io.apicurio.registry.rest.v3.beans.DownloadRef;
import io.apicurio.registry.rest.v3.beans.RoleMapping;
import io.apicurio.registry.rest.v3.beans.RoleMappingSearchResults;
import io.apicurio.registry.rest.v3.beans.Rule;
import io.apicurio.registry.rest.v3.beans.SnapshotMetaData;
import io.apicurio.registry.rest.v3.beans.UpdateConfigurationProperty;
import io.apicurio.registry.rest.v3.beans.UpdateRole;
import io.apicurio.registry.rest.v3.shared.DataExporter;
import io.apicurio.registry.rules.DefaultRuleDeletionException;
import io.apicurio.registry.rules.RulesProperties;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.DownloadContextDto;
import io.apicurio.registry.storage.dto.DownloadContextType;
import io.apicurio.registry.storage.dto.RoleMappingDto;
import io.apicurio.registry.storage.dto.RoleMappingSearchResultsDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.error.ConfigPropertyNotFoundException;
import io.apicurio.registry.storage.error.InvalidPropertyValueException;
import io.apicurio.registry.storage.error.RuleNotFoundException;
import io.apicurio.registry.storage.importing.ImportExportConfigProperties;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.utils.DtoUtil;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityInputStream;
import io.apicurio.registry.utils.impexp.EntityInputStreamImpl;
import io.apicurio.registry.utils.impexp.EntityReader;
import io.apicurio.registry.utils.impexp.EntityType;
import io.apicurio.registry.utils.impexp.ManifestEntity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class AdminResourceImpl
implements AdminResource {
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesProperties rulesProperties;
    @Inject
    DynamicConfigPropertyIndex dynamicPropertyIndex;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Inject
    Config config;
    @Inject
    DataExporter exporter;
    @Inject
    ImportExportConfigProperties importExportProps;
    @Context
    HttpServletRequest request;
    @Dynamic(label="Download link expiry", description="The number of seconds that a generated link to a .zip download file is active before expiring.")
    @ConfigProperty(name="apicurio.download.href.ttl.seconds", defaultValue="30")
    @Info(category="download", description="Download link expiry", availableSince="2.1.2.Final")
    Supplier<Long> downloadHrefTtl;

    private static void requireParameter(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            throw new MissingRequiredParameterException(parameterName);
        }
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public List<ArtifactTypeInfo> listArtifactTypes() {
        return this.factory.getAllArtifactTypes().stream().map(t -> {
            ArtifactTypeInfo ati = new ArtifactTypeInfo();
            ati.setName((String)t);
            return ati;
        }).collect(Collectors.toList());
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public SnapshotMetaData triggerSnapshot() {
        this.storage.triggerSnapshotCreation();
        return SnapshotMetaData.builder().build();
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public List<RuleType> listGlobalRules() {
        List<RuleType> rules = this.storage.getGlobalRules();
        Set<RuleType> defaultRules = this.rulesProperties.getDefaultGlobalRules();
        return Stream.concat(rules.stream(), defaultRules.stream()).collect(Collectors.toSet()).stream().sorted().collect(Collectors.toList());
    }

    @Override
    @Audited(extractParameters={"0", "rule"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void createGlobalRule(CreateRule data) {
        RuleType ruleType = data.getRuleType();
        AdminResourceImpl.requireParameter("ruleType", (Object)ruleType);
        if (data.getConfig() == null || data.getConfig().isEmpty()) {
            throw new MissingRequiredParameterException("Config");
        }
        RuleConfigurationDto configDto = new RuleConfigurationDto();
        configDto.setConfiguration(data.getConfig());
        this.storage.createGlobalRule(data.getRuleType(), configDto);
    }

    @Override
    @Audited
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void deleteAllGlobalRules() {
        this.storage.deleteGlobalRules();
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public Rule getGlobalRuleConfig(RuleType ruleType) {
        RuleConfigurationDto dto;
        block2: {
            try {
                dto = this.storage.getGlobalRule(ruleType);
            }
            catch (RuleNotFoundException ruleNotFoundException) {
                dto = this.rulesProperties.getDefaultGlobalRuleConfiguration(ruleType);
                if (dto != null) break block2;
                throw ruleNotFoundException;
            }
        }
        Rule ruleBean = new Rule();
        ruleBean.setRuleType(ruleType);
        ruleBean.setConfig(dto.getConfiguration());
        return ruleBean;
    }

    @Override
    @Audited(extractParameters={"0", "rule_type", "1", "rule"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public Rule updateGlobalRuleConfig(RuleType ruleType, Rule data) {
        RuleConfigurationDto configDto = new RuleConfigurationDto();
        configDto.setConfiguration(data.getConfig());
        try {
            this.storage.updateGlobalRule(ruleType, configDto);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            if (this.rulesProperties.isDefaultGlobalRuleConfigured(ruleType)) {
                this.storage.createGlobalRule(ruleType, configDto);
            }
            throw ruleNotFoundException;
        }
        Rule ruleBean = new Rule();
        ruleBean.setRuleType(ruleType);
        ruleBean.setConfig(data.getConfig());
        return ruleBean;
    }

    @Override
    @Audited(extractParameters={"0", "rule_type"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void deleteGlobalRule(RuleType rule) {
        try {
            this.storage.deleteGlobalRule(rule);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            if (this.rulesProperties.isDefaultGlobalRuleConfigured(rule)) {
                throw new DefaultRuleDeletionException(rule);
            }
            throw ruleNotFoundException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Audited
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void importData(Boolean xRegistryPreserveGlobalId, Boolean xRegistryPreserveContentId, Boolean requireEmptyRegistry, InputStream data) {
        boolean requireEmpty;
        boolean preserveGlobalId = xRegistryPreserveGlobalId == null ? this.importExportProps.preserveGlobalId : xRegistryPreserveGlobalId;
        boolean preserveContentId = xRegistryPreserveContentId == null ? this.importExportProps.preserveContentId : xRegistryPreserveContentId;
        boolean bl = requireEmpty = requireEmptyRegistry == null ? this.importExportProps.requireEmptyRegistry : requireEmptyRegistry;
        if (requireEmpty && !this.storage.isEmpty()) {
            throw new ConflictException("Registry is not empty.");
        }
        ZipInputStream zip = new ZipInputStream(data, StandardCharsets.UTF_8);
        Path tempDirectory = null;
        try {
            tempDirectory = Files.createTempDirectory(Paths.get(this.importExportProps.workDir, new String[0]), "apicurio-import_", new FileAttribute[0]);
            IoUtil.unpackToDisk(zip, tempDirectory);
            zip.close();
        }
        catch (IOException e) {
            throw new BadRequestException("Error importing data: " + e.getMessage(), (Throwable)e);
        }
        try {
            boolean upgrade;
            EntityReader reader;
            block17: {
                reader = new EntityReader(tempDirectory);
                upgrade = false;
                try {
                    Entity entity = reader.readNextEntity();
                    if (entity.getEntityType() != EntityType.Manifest) {
                        throw new BadRequestException("Invalid import file: missing Manifest file");
                    }
                    ManifestEntity manifestEntity = (ManifestEntity)entity;
                    if (manifestEntity.exportVersion.startsWith("3")) {
                        upgrade = false;
                        break block17;
                    }
                    if (manifestEntity.exportVersion.startsWith("2") || manifestEntity.exportVersion.startsWith("1")) {
                        upgrade = true;
                        break block17;
                    }
                    throw new BadRequestException("Invalid import file, unknown manifest version: " + manifestEntity.systemVersion);
                }
                catch (IOException e) {
                    throw new BadRequestException("Error importing data: " + e.getMessage(), (Throwable)e);
                }
            }
            EntityInputStreamImpl stream = new EntityInputStreamImpl(reader);
            if (upgrade) {
                this.storage.upgradeData((EntityInputStream)stream, preserveGlobalId, preserveContentId);
            } else {
                this.storage.importData((EntityInputStream)stream, preserveGlobalId, preserveContentId);
            }
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)tempDirectory.toFile());
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    @Audited(extractParameters={"0", "for_browser"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public Response exportData(Boolean forBrowser) {
        String acceptHeader = this.request.getHeader("Accept");
        if (Boolean.TRUE.equals(forBrowser) || "application/json".equals(acceptHeader)) {
            long expires = System.currentTimeMillis() + this.downloadHrefTtl.get() * 1000L;
            DownloadContextDto downloadCtx = DownloadContextDto.builder().type(DownloadContextType.EXPORT).expires(expires).build();
            String downloadId = this.storage.createDownload(downloadCtx);
            String downloadHref = this.createDownloadHref(downloadId);
            DownloadRef downloadRef = new DownloadRef();
            downloadRef.setDownloadId(downloadId);
            downloadRef.setHref(downloadHref);
            return Response.ok((Object)downloadRef).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return this.exporter.exportData();
    }

    @Override
    @Audited(extractParameters={"0", "role_mapping"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public void createRoleMapping(RoleMapping data) {
        this.storage.createRoleMapping(data.getPrincipalId(), data.getRole().name(), data.getPrincipalName());
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public RoleMappingSearchResults listRoleMappings(BigInteger limit, BigInteger offset) {
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        RoleMappingSearchResultsDto dto = this.storage.searchRoleMappings(offset.intValue(), limit.intValue());
        return V3ApiUtil.dtoToRoleMappingSearchResults(dto);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public RoleMapping getRoleMapping(String principalId) {
        RoleMappingDto dto = this.storage.getRoleMapping(principalId);
        return V3ApiUtil.dtoToRoleMapping(dto);
    }

    @Override
    @Audited(extractParameters={"0", "principal_id", "1", "update_role"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public void updateRoleMapping(String principalId, UpdateRole data) {
        AdminResourceImpl.requireParameter("principalId", principalId);
        AdminResourceImpl.requireParameter("role", (Object)data.getRole());
        this.storage.updateRoleMapping(principalId, data.getRole().name());
    }

    @Override
    @Audited(extractParameters={"0", "principal_id"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public void deleteRoleMapping(String principalId) {
        this.storage.deleteRoleMapping(principalId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public List<ConfigurationProperty> listConfigProperties() {
        List props = this.storage.getConfigProperties();
        HashMap propsI = new HashMap();
        props.forEach(dto -> propsI.put(dto.getName(), dto));
        return this.dynamicPropertyIndex.getAcceptedPropertyNames().stream().sorted(String::compareTo).map(pname -> propsI.containsKey(pname) ? V3ApiUtil.dtoToConfigurationProperty(this.dynamicPropertyIndex.getProperty(pname), (DynamicConfigPropertyDto)propsI.get(pname)) : this.defToConfigurationProperty(this.dynamicPropertyIndex.getProperty(pname))).collect(Collectors.toList());
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public ConfigurationProperty getConfigProperty(String propertyName) {
        DynamicConfigPropertyDef def = this.resolveConfigProperty(propertyName);
        DynamicConfigPropertyDto dto = this.storage.getRawConfigProperty(propertyName);
        if (dto == null) {
            return this.defToConfigurationProperty(def);
        }
        return V3ApiUtil.dtoToConfigurationProperty(def, dto);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void updateConfigProperty(String propertyName, UpdateConfigurationProperty data) {
        DynamicConfigPropertyDef propertyDef = this.resolveConfigProperty(propertyName);
        this.validateConfigPropertyValue(propertyDef, data.getValue());
        DynamicConfigPropertyDto dto = new DynamicConfigPropertyDto();
        dto.setName(propertyName);
        dto.setValue(data.getValue());
        this.storage.setConfigProperty(dto);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @Audited(extractParameters={"0", "name"})
    public void resetConfigProperty(String propertyName) {
        this.resolveConfigProperty(propertyName);
        this.storage.deleteConfigProperty(propertyName);
    }

    private static boolean isNullOrTrue(Boolean value) {
        return value == null || value != false;
    }

    private String createDownloadHref(String downloadId) {
        return "/apis/registry/v3/downloads/" + downloadId;
    }

    private ConfigurationProperty defToConfigurationProperty(DynamicConfigPropertyDef def) {
        String propertyValue = this.config.getOptionalValue(def.getName(), String.class).orElse(def.getDefaultValue());
        ConfigurationProperty rval = new ConfigurationProperty();
        rval.setName(DtoUtil.appAuthPropertyToRegistry(def.getName()));
        rval.setValue(propertyValue);
        rval.setType(def.getType().getName());
        rval.setLabel(def.getLabel());
        rval.setDescription(def.getDescription());
        return rval;
    }

    private DynamicConfigPropertyDef resolveConfigProperty(String propertyName) {
        DynamicConfigPropertyDef property = this.dynamicPropertyIndex.getProperty(propertyName);
        if (property == null) {
            propertyName = DtoUtil.registryAuthPropertyToApp(propertyName);
        }
        if ((property = this.dynamicPropertyIndex.getProperty(propertyName)) == null) {
            throw new ConfigPropertyNotFoundException(propertyName);
        }
        if (!this.dynamicPropertyIndex.isAccepted(propertyName)) {
            throw new ConfigPropertyNotFoundException(propertyName);
        }
        return property;
    }

    private void validateConfigPropertyValue(DynamicConfigPropertyDef propertyDef, String value) {
        if (!propertyDef.isValidValue(value)) {
            throw new InvalidPropertyValueException("Invalid dynamic configuration property value for: " + propertyDef.getName());
        }
    }
}

