/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v3;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.logging.audit.Audited;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.model.BranchId;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.model.GAV;
import io.apicurio.registry.model.GroupId;
import io.apicurio.registry.model.VersionExpressionParser;
import io.apicurio.registry.model.VersionId;
import io.apicurio.registry.rest.HeadersHack;
import io.apicurio.registry.rest.MissingRequiredParameterException;
import io.apicurio.registry.rest.RestConfig;
import io.apicurio.registry.rest.v3.AbstractResourceImpl;
import io.apicurio.registry.rest.v3.GroupsResource;
import io.apicurio.registry.rest.v3.V3ApiUtil;
import io.apicurio.registry.rest.v3.beans.AddVersionToBranch;
import io.apicurio.registry.rest.v3.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v3.beans.ArtifactReference;
import io.apicurio.registry.rest.v3.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v3.beans.ArtifactSortBy;
import io.apicurio.registry.rest.v3.beans.BranchMetaData;
import io.apicurio.registry.rest.v3.beans.BranchSearchResults;
import io.apicurio.registry.rest.v3.beans.Comment;
import io.apicurio.registry.rest.v3.beans.CreateArtifact;
import io.apicurio.registry.rest.v3.beans.CreateArtifactResponse;
import io.apicurio.registry.rest.v3.beans.CreateBranch;
import io.apicurio.registry.rest.v3.beans.CreateGroup;
import io.apicurio.registry.rest.v3.beans.CreateRule;
import io.apicurio.registry.rest.v3.beans.CreateVersion;
import io.apicurio.registry.rest.v3.beans.EditableArtifactMetaData;
import io.apicurio.registry.rest.v3.beans.EditableBranchMetaData;
import io.apicurio.registry.rest.v3.beans.EditableGroupMetaData;
import io.apicurio.registry.rest.v3.beans.EditableVersionMetaData;
import io.apicurio.registry.rest.v3.beans.GroupMetaData;
import io.apicurio.registry.rest.v3.beans.GroupSearchResults;
import io.apicurio.registry.rest.v3.beans.GroupSortBy;
import io.apicurio.registry.rest.v3.beans.HandleReferencesType;
import io.apicurio.registry.rest.v3.beans.IfArtifactExists;
import io.apicurio.registry.rest.v3.beans.NewComment;
import io.apicurio.registry.rest.v3.beans.ReplaceBranchVersions;
import io.apicurio.registry.rest.v3.beans.Rule;
import io.apicurio.registry.rest.v3.beans.SortOrder;
import io.apicurio.registry.rest.v3.beans.VersionMetaData;
import io.apicurio.registry.rest.v3.beans.VersionSearchResults;
import io.apicurio.registry.rest.v3.beans.VersionSortBy;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.BranchMetaDataDto;
import io.apicurio.registry.storage.dto.BranchSearchResultsDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.EditableBranchMetaDataDto;
import io.apicurio.registry.storage.dto.EditableGroupMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.storage.error.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.GroupNotFoundException;
import io.apicurio.registry.storage.error.InvalidArtifactIdException;
import io.apicurio.registry.storage.error.InvalidGroupIdException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import io.apicurio.registry.storage.impl.sql.RegistryContentUtils;
import io.apicurio.registry.types.ReferenceType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.VersionState;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.util.ArtifactIdGenerator;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.utils.ArtifactIdValidator;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class GroupsResourceImpl
extends AbstractResourceImpl
implements GroupsResource {
    private static final String EMPTY_CONTENT_ERROR_MESSAGE = "Empty content is not allowed.";
    private static final Integer GET_GROUPS_LIMIT = 1000;
    @Inject
    RulesService rulesService;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Inject
    ArtifactIdGenerator idGenerator;
    @Inject
    RestConfig restConfig;
    @Inject
    SecurityIdentity securityIdentity;

    @Override
    public List<ArtifactReference> getArtifactVersionReferences(String groupId, String artifactId, String versionExpression, ReferenceType refType) {
        GAV gav = VersionExpressionParser.parse(new GA(groupId, artifactId), versionExpression, (ga, branchId) -> this.storage.getBranchTip((GA)ga, (BranchId)branchId, RegistryStorage.RetrievalBehavior.DEFAULT));
        if (refType == null || refType == ReferenceType.OUTBOUND) {
            return this.storage.getArtifactVersionContent(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId()).getReferences().stream().map(V3ApiUtil::referenceDtoToReference).collect(Collectors.toList());
        }
        return this.storage.getInboundArtifactReferences(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId()).stream().map(V3ApiUtil::referenceDtoToReference).collect(Collectors.toList());
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifact(String groupId, String artifactId) {
        if (!this.restConfig.isArtifactDeletionEnabled()) {
            throw new NotAllowedException("Artifact deletion operation is not enabled.", "GET", (String[])null);
        }
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        this.storage.deleteArtifact(new GroupId(groupId).getRawGroupIdWithNull(), artifactId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public ArtifactMetaData getArtifactMetaData(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(new GroupId(groupId).getRawGroupIdWithNull(), artifactId);
        return V3ApiUtil.dtoToArtifactMetaData(dto);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "editable_metadata"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactMetaData(String groupId, String artifactId, EditableArtifactMetaData data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (data.getOwner() != null && data.getOwner().trim().isEmpty()) {
            throw new MissingRequiredParameterException("Owner cannot be empty");
        }
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        dto.setOwner(data.getOwner());
        dto.setLabels(data.getLabels());
        this.storage.updateArtifactMetaData(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, dto);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public GroupMetaData getGroupById(String groupId) {
        GroupMetaDataDto group = this.storage.getGroupMetaData(groupId);
        return V3ApiUtil.groupDtoToGroup(group);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public void deleteGroupById(String groupId) {
        if (!this.restConfig.isGroupDeletionEnabled()) {
            throw new NotAllowedException("Group deletion operation is not enabled.", "GET", (String[])null);
        }
        this.storage.deleteGroup(groupId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public void updateGroupById(String groupId, EditableGroupMetaData data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        EditableGroupMetaDataDto dto = new EditableGroupMetaDataDto();
        dto.setDescription(data.getDescription());
        dto.setLabels(data.getLabels());
        this.storage.updateGroupMetaData(new GroupId(groupId).getRawGroupIdWithNull(), dto);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public GroupSearchResults listGroups(BigInteger limit, BigInteger offset, SortOrder order, GroupSortBy orderby) {
        if (orderby == null) {
            orderby = GroupSortBy.groupId;
        }
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        Set<SearchFilter> filters = Collections.emptySet();
        GroupSearchResultsDto resultsDto = this.storage.searchGroups(filters, oBy, oDir, offset.intValue(), limit.intValue());
        return V3ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Write)
    public GroupMetaData createGroup(CreateGroup data) {
        GroupMetaDataDto.GroupMetaDataDtoBuilder group = GroupMetaDataDto.builder().groupId(data.getGroupId()).description(data.getDescription()).labels(data.getLabels());
        String user = this.securityIdentity.getPrincipal().getName();
        group.owner(user).createdOn(new Date().getTime());
        this.storage.createGroup(group.build());
        return V3ApiUtil.groupDtoToGroup(this.storage.getGroupMetaData(data.getGroupId()));
    }

    @Override
    public List<RuleType> listGroupRules(String groupId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        return this.storage.getGroupRules(new GroupId(groupId).getRawGroupIdWithNull());
    }

    @Override
    public void createGroupRule(String groupId, CreateRule data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("ruleType", (Object)data.getRuleType());
        GroupsResourceImpl.requireParameter("config", data.getConfig());
        if (data.getConfig() == null || data.getConfig().isEmpty()) {
            throw new MissingRequiredParameterException("config");
        }
        if (new GroupId(groupId).isDefaultGroup()) {
            throw new NotAllowedException("Default group is not allowed", new String[0]);
        }
        RuleConfigurationDto config = new RuleConfigurationDto();
        config.setConfiguration(data.getConfig());
        if (!this.storage.isGroupExists(new GroupId(groupId).getRawGroupIdWithNull())) {
            throw new GroupNotFoundException(groupId);
        }
        this.storage.createGroupRule(new GroupId(groupId).getRawGroupIdWithNull(), data.getRuleType(), config);
    }

    @Override
    public Rule updateGroupRuleConfig(String groupId, RuleType ruleType, Rule data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("ruleType", (Object)ruleType);
        GroupsResourceImpl.requireParameter("config", data.getConfig());
        RuleConfigurationDto dto = new RuleConfigurationDto(data.getConfig());
        this.storage.updateGroupRule(new GroupId(groupId).getRawGroupIdWithNull(), ruleType, dto);
        Rule rval = new Rule();
        rval.setRuleType(ruleType);
        rval.setConfig(data.getConfig());
        return rval;
    }

    @Override
    public void deleteGroupRules(String groupId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        this.storage.deleteGroupRules(new GroupId(groupId).getRawGroupIdWithNull());
    }

    @Override
    public Rule getGroupRuleConfig(String groupId, RuleType ruleType) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("ruleType", (Object)ruleType);
        RuleConfigurationDto dto = this.storage.getGroupRule(new GroupId(groupId).getRawGroupIdWithNull(), ruleType);
        Rule rval = new Rule();
        rval.setConfig(dto.getConfiguration());
        rval.setRuleType(ruleType);
        return rval;
    }

    @Override
    public void deleteGroupRule(String groupId, RuleType rule) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("rule", (Object)rule);
        this.storage.deleteGroupRule(new GroupId(groupId).getRawGroupIdWithNull(), rule);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public List<RuleType> listArtifactRules(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        return this.storage.getArtifactRules(new GroupId(groupId).getRawGroupIdWithNull(), artifactId);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "rule"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void createArtifactRule(String groupId, String artifactId, CreateRule data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("ruleType", (Object)data.getRuleType());
        GroupsResourceImpl.requireParameter("config", data.getConfig());
        if (data.getConfig() == null || data.getConfig().isEmpty()) {
            throw new MissingRequiredParameterException("Config");
        }
        RuleConfigurationDto config = new RuleConfigurationDto();
        config.setConfiguration(data.getConfig());
        if (!this.storage.isArtifactExists(new GroupId(groupId).getRawGroupIdWithNull(), artifactId)) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        this.storage.createArtifactRule(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, data.getRuleType(), config);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactRules(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        this.storage.deleteArtifactRules(new GroupId(groupId).getRawGroupIdWithNull(), artifactId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Rule getArtifactRuleConfig(String groupId, String artifactId, RuleType ruleType) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("ruleType", (Object)ruleType);
        RuleConfigurationDto dto = this.storage.getArtifactRule(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, ruleType);
        Rule rval = new Rule();
        rval.setConfig(dto.getConfiguration());
        rval.setRuleType(ruleType);
        return rval;
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "rule_type", "3", "rule"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public Rule updateArtifactRuleConfig(String groupId, String artifactId, RuleType ruleType, Rule data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("ruleType", (Object)ruleType);
        GroupsResourceImpl.requireParameter("config", data.getConfig());
        RuleConfigurationDto dto = new RuleConfigurationDto(data.getConfig());
        this.storage.updateArtifactRule(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, ruleType, dto);
        Rule rval = new Rule();
        rval.setRuleType(ruleType);
        rval.setConfig(data.getConfig());
        return rval;
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "rule_type"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("rule", (Object)rule);
        this.storage.deleteArtifactRule(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, rule);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Response getArtifactVersionContent(String groupId, String artifactId, String versionExpression, HandleReferencesType references) {
        ArtifactVersionMetaDataDto metaData;
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("versionExpression", versionExpression);
        GAV gav = VersionExpressionParser.parse(new GA(groupId, artifactId), versionExpression, (ga, branchId) -> this.storage.getBranchTip((GA)ga, (BranchId)branchId, RegistryStorage.RetrievalBehavior.SKIP_DISABLED_LATEST));
        if (references == null) {
            references = HandleReferencesType.PRESERVE;
        }
        if (VersionState.DISABLED.equals((Object)(metaData = this.storage.getArtifactVersionMetaData(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId())).getState())) {
            throw new VersionNotFoundException(groupId, artifactId, versionExpression);
        }
        StoredArtifactVersionDto artifact = this.storage.getArtifactVersionContent(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId());
        TypedContent contentToReturn = TypedContent.create((ContentHandle)artifact.getContent(), (String)artifact.getContentType());
        contentToReturn = this.handleContentReferences(references, metaData.getArtifactType(), contentToReturn, artifact.getReferences());
        Response.ResponseBuilder builder = Response.ok((Object)contentToReturn.getContent(), (String)artifact.getContentType());
        this.checkIfDeprecated(metaData::getState, groupId, artifactId, versionExpression, builder);
        return builder.build();
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactVersion(String groupId, String artifactId, String version) {
        if (!this.restConfig.isArtifactVersionDeletionEnabled()) {
            throw new NotAllowedException("Artifact version deletion operation is not enabled.", "GET", (String[])null);
        }
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        GAV gav = VersionExpressionParser.parse(new GA(groupId, artifactId), version, (ga, branchId) -> this.storage.getBranchTip((GA)ga, (BranchId)branchId, RegistryStorage.RetrievalBehavior.DEFAULT));
        this.storage.deleteArtifactVersion(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId());
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaData(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        GAV gav = VersionExpressionParser.parse(new GA(groupId, artifactId), version, (ga, branchId) -> this.storage.getBranchTip((GA)ga, (BranchId)branchId, RegistryStorage.RetrievalBehavior.SKIP_DISABLED_LATEST));
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId());
        return V3ApiUtil.dtoToVersionMetaData(dto);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "editable_metadata"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String versionExpression, EditableVersionMetaData data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("versionExpression", versionExpression);
        GAV gav = VersionExpressionParser.parse(new GA(groupId, artifactId), versionExpression, (ga, branchId) -> this.storage.getBranchTip((GA)ga, (BranchId)branchId, RegistryStorage.RetrievalBehavior.DEFAULT));
        EditableVersionMetaDataDto dto = new EditableVersionMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        dto.setLabels(data.getLabels());
        dto.setState(data.getState());
        this.storage.updateArtifactVersionMetaData(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId(), dto);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public Comment addArtifactVersionComment(String groupId, String artifactId, String versionExpression, NewComment data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("versionExpression", versionExpression);
        GAV gav = VersionExpressionParser.parse(new GA(groupId, artifactId), versionExpression, (ga, branchId) -> this.storage.getBranchTip((GA)ga, (BranchId)branchId, RegistryStorage.RetrievalBehavior.DEFAULT));
        CommentDto newComment = this.storage.createArtifactVersionComment(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId(), data.getValue());
        return V3ApiUtil.commentDtoToComment(newComment);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "comment_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactVersionComment(String groupId, String artifactId, String versionExpression, String commentId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("versionExpression", versionExpression);
        GroupsResourceImpl.requireParameter("commentId", commentId);
        GAV gav = VersionExpressionParser.parse(new GA(groupId, artifactId), versionExpression, (ga, branchId) -> this.storage.getBranchTip((GA)ga, (BranchId)branchId, RegistryStorage.RetrievalBehavior.DEFAULT));
        this.storage.deleteArtifactVersionComment(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId(), commentId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public List<Comment> getArtifactVersionComments(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        GAV gav = VersionExpressionParser.parse(new GA(groupId, artifactId), version, (ga, branchId) -> this.storage.getBranchTip((GA)ga, (BranchId)branchId, RegistryStorage.RetrievalBehavior.DEFAULT));
        return this.storage.getArtifactVersionComments(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId()).stream().map(V3ApiUtil::commentDtoToComment).collect(Collectors.toList());
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "comment_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactVersionComment(String groupId, String artifactId, String versionExpression, String commentId, NewComment data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("versionExpression", versionExpression);
        GroupsResourceImpl.requireParameter("commentId", commentId);
        GroupsResourceImpl.requireParameter("value", data.getValue());
        GAV gav = VersionExpressionParser.parse(new GA(groupId, artifactId), versionExpression, (ga, branchId) -> this.storage.getBranchTip((GA)ga, (BranchId)branchId, RegistryStorage.RetrievalBehavior.DEFAULT));
        this.storage.updateArtifactVersionComment(gav.getRawGroupIdWithNull(), gav.getRawArtifactId(), gav.getRawVersionId(), commentId, data.getValue());
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Read)
    public ArtifactSearchResults listArtifactsInGroup(String groupId, BigInteger limit, BigInteger offset, SortOrder order, ArtifactSortBy orderby) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        if (orderby == null) {
            orderby = ArtifactSortBy.name;
        }
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        filters.add(SearchFilter.ofGroupId(new GroupId(groupId).getRawGroupIdWithNull()));
        ArtifactSearchResultsDto resultsDto = this.storage.searchArtifacts(filters, oBy, oDir, offset.intValue(), limit.intValue());
        return V3ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Override
    @Audited(extractParameters={"0", "group_id"})
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public void deleteArtifactsInGroup(String groupId) {
        if (!this.restConfig.isArtifactDeletionEnabled()) {
            throw new NotAllowedException("Artifact deletion operation is not enabled.", "GET", (String[])null);
        }
        GroupsResourceImpl.requireParameter("groupId", groupId);
        this.storage.deleteArtifacts(new GroupId(groupId).getRawGroupIdWithNull());
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "if_exists", "2", "canonical", "3", "dryRun"})
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write, dryRunParam=3)
    public CreateArtifactResponse createArtifact(String groupId, IfArtifactExists ifExists, Boolean canonical, Boolean dryRun, CreateArtifact data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        if (data.getFirstVersion() != null) {
            GroupsResourceImpl.requireParameter("body.firstVersion.content", data.getFirstVersion().getContent());
            GroupsResourceImpl.requireParameter("body.firstVersion.content.content", data.getFirstVersion().getContent().getContent());
            GroupsResourceImpl.requireParameter("body.firstVersion.content.contentType", data.getFirstVersion().getContent().getContentType());
            if (data.getFirstVersion().getBranches() == null) {
                data.getFirstVersion().setBranches(Collections.emptyList());
            }
        } else {
            GroupsResourceImpl.requireParameter("body.artifactType", data.getArtifactType());
        }
        if (!ArtifactIdValidator.isGroupIdAllowed(groupId)) {
            throw new InvalidGroupIdException("Character % and non ASCII characters are not allowed in group IDs.");
        }
        boolean fcanonical = canonical == null ? Boolean.FALSE : canonical;
        String artifactId = data.getArtifactId();
        String contentType = this.getContentType(data);
        ContentHandle content = this.getContent(data);
        List<ArtifactReference> references = this.getReferences(data);
        if (content != null && content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        try {
            if (artifactId == null || artifactId.trim().isEmpty()) {
                artifactId = this.idGenerator.generate();
            } else if (!ArtifactIdValidator.isArtifactIdAllowed(artifactId)) {
                throw new InvalidArtifactIdException("Character % and non ASCII characters are not allowed in artifact IDs.");
            }
            TypedContent typedContent = TypedContent.create((ContentHandle)content, (String)contentType);
            String artifactType = ArtifactTypeUtil.determineArtifactType(typedContent, data.getArtifactType(), this.factory);
            List<ArtifactReferenceDto> referencesAsDtos = this.toReferenceDtos(references);
            Map<String, TypedContent> resolvedReferences = RegistryContentUtils.recursivelyResolveReferences(referencesAsDtos, this.storage::getContentByReference);
            if (content != null) {
                this.rulesService.applyRules(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, artifactType, typedContent, RuleApplicationType.CREATE, references, resolvedReferences);
            }
            EditableArtifactMetaDataDto artifactMetaData = EditableArtifactMetaDataDto.builder().description(data.getDescription()).name(data.getName()).labels(data.getLabels()).build();
            String firstVersion = null;
            ContentWrapperDto firstVersionContent = null;
            EditableVersionMetaDataDto firstVersionMetaData = null;
            List<String> firstVersionBranches = null;
            if (data.getFirstVersion() != null) {
                firstVersion = data.getFirstVersion().getVersion();
                firstVersionContent = ContentWrapperDto.builder().content(content).contentType(contentType).references(referencesAsDtos).build();
                firstVersionMetaData = EditableVersionMetaDataDto.builder().description(data.getFirstVersion().getDescription()).name(data.getFirstVersion().getName()).labels(data.getFirstVersion().getLabels()).build();
                firstVersionBranches = data.getFirstVersion().getBranches();
            }
            Pair<ArtifactMetaDataDto, ArtifactVersionMetaDataDto> storageResult = this.storage.createArtifact(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, artifactType, artifactMetaData, firstVersion, firstVersionContent, firstVersionMetaData, firstVersionBranches, dryRun != null && dryRun != false);
            Object rval = ((CreateArtifactResponse.CreateArtifactResponseBuilder)CreateArtifactResponse.builder().artifact(V3ApiUtil.dtoToArtifactMetaData((ArtifactMetaDataDto)storageResult.getLeft()))).build();
            if (storageResult.getRight() != null) {
                ((CreateArtifactResponse)rval).setVersion(V3ApiUtil.dtoToVersionMetaData((ArtifactVersionMetaDataDto)storageResult.getRight()));
            }
            return rval;
        }
        catch (ArtifactAlreadyExistsException ex) {
            return this.handleIfExists(groupId, artifactId, ifExists, data.getFirstVersion(), fcanonical);
        }
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionSearchResults listArtifactVersions(String groupId, String artifactId, BigInteger offset, BigInteger limit, SortOrder order, VersionSortBy orderby) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (orderby == null) {
            orderby = VersionSortBy.createdOn;
        }
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        GroupId gid = new GroupId(groupId);
        this.storage.getArtifactMetaData(gid.getRawGroupIdWithNull(), artifactId);
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection oDir = order == null || order == SortOrder.desc ? OrderDirection.asc : OrderDirection.desc;
        Set<SearchFilter> filters = Set.of(SearchFilter.ofGroupId(new GroupId(groupId).getRawGroupIdWithNull()), SearchFilter.ofArtifactId(artifactId));
        VersionSearchResultsDto resultsDto = this.storage.searchVersions(filters, oBy, oDir, offset.intValue(), limit.intValue());
        return V3ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "dryRun"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write, dryRunParam=2)
    public VersionMetaData createArtifactVersion(String groupId, String artifactId, Boolean dryRun, CreateVersion data) {
        GroupsResourceImpl.requireParameter("content", data.getContent());
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("body.content", data.getContent());
        GroupsResourceImpl.requireParameter("body.content.content", data.getContent().getContent());
        GroupsResourceImpl.requireParameter("body.content.contentType", data.getContent().getContentType());
        ContentHandle content = ContentHandle.create((String)data.getContent().getContent());
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = data.getContent().getContentType();
        List<ArtifactReferenceDto> referencesAsDtos = this.toReferenceDtos(data.getContent().getReferences());
        Map<String, TypedContent> resolvedReferences = RegistryContentUtils.recursivelyResolveReferences(referencesAsDtos, this.storage::getContentByReference);
        String artifactType = this.lookupArtifactType(groupId, artifactId);
        TypedContent typedContent = TypedContent.create((ContentHandle)content, (String)ct);
        this.rulesService.applyRules(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, artifactType, typedContent, RuleApplicationType.UPDATE, data.getContent().getReferences(), resolvedReferences);
        EditableVersionMetaDataDto metaDataDto = EditableVersionMetaDataDto.builder().description(data.getDescription()).name(data.getName()).labels(data.getLabels()).build();
        ContentWrapperDto contentDto = ContentWrapperDto.builder().contentType(ct).content(content).references(referencesAsDtos).build();
        ArtifactVersionMetaDataDto vmd = this.storage.createArtifactVersion(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, data.getVersion(), artifactType, contentDto, metaDataDto, data.getBranches(), dryRun != null && dryRun != false);
        return V3ApiUtil.dtoToVersionMetaData(vmd);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public BranchMetaData createBranch(String groupId, String artifactId, CreateBranch data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("branchId", data.getBranchId());
        GA ga = new GA(groupId, artifactId);
        BranchId bid = new BranchId(data.getBranchId());
        BranchMetaDataDto branchDto = this.storage.createBranch(ga, bid, data.getDescription(), data.getVersions());
        return V3ApiUtil.dtoToBranchMetaData(branchDto);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public BranchSearchResults listBranches(String groupId, String artifactId, BigInteger offset, BigInteger limit) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        BranchSearchResultsDto dto = this.storage.getBranches(new GA(groupId, artifactId), offset.intValue(), limit.intValue());
        return V3ApiUtil.dtoToSearchResults(dto);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public BranchMetaData getBranchMetaData(String groupId, String artifactId, String branchId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        BranchMetaDataDto branch = this.storage.getBranchMetaData(new GA(groupId, artifactId), new BranchId(branchId));
        return V3ApiUtil.dtoToBranchMetaData(branch);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateBranchMetaData(String groupId, String artifactId, String branchId, EditableBranchMetaData data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("branchId", branchId);
        EditableBranchMetaDataDto dto = EditableBranchMetaDataDto.builder().description(data.getDescription()).build();
        this.storage.updateBranchMetaData(new GA(groupId, artifactId), new BranchId(branchId), dto);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteBranch(String groupId, String artifactId, String branchId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("branchId", branchId);
        this.storage.deleteBranch(new GA(groupId, artifactId), new BranchId(branchId));
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionSearchResults listBranchVersions(String groupId, String artifactId, String branchId, BigInteger offset, BigInteger limit) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("branchId", branchId);
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        GA ga = new GA(groupId, artifactId);
        BranchId bid = new BranchId(branchId);
        this.storage.getBranchMetaData(ga, bid);
        VersionSearchResultsDto results = this.storage.getBranchVersions(ga, bid, offset.intValue(), limit.intValue());
        return V3ApiUtil.dtoToSearchResults(results);
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void replaceBranchVersions(String groupId, String artifactId, String branchId, ReplaceBranchVersions data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("branchId", branchId);
        GroupsResourceImpl.requireParameter("versions", data.getVersions());
        GA ga = new GA(groupId, artifactId);
        BranchId bid = new BranchId(branchId);
        this.storage.getBranchMetaData(ga, bid);
        this.storage.replaceBranchVersions(ga, bid, data.getVersions().stream().map(VersionId::new).toList());
    }

    @Override
    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void addVersionToBranch(String groupId, String artifactId, String branchId, AddVersionToBranch data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("branchId", branchId);
        GA ga = new GA(groupId, artifactId);
        BranchId bid = new BranchId(branchId);
        this.storage.getBranchMetaData(ga, bid);
        this.storage.appendVersionToBranch(ga, bid, new VersionId(data.getVersion()));
    }

    private void checkIfDeprecated(Supplier<VersionState> stateSupplier, String groupId, String artifactId, String version, Response.ResponseBuilder builder) {
        HeadersHack.checkIfDeprecated(stateSupplier, groupId, artifactId, version, builder);
    }

    private String lookupArtifactType(String groupId, String artifactId) {
        return this.storage.getArtifactMetaData(new GroupId(groupId).getRawGroupIdWithNull(), artifactId).getArtifactType();
    }

    private String getContentType(CreateArtifact data) {
        if (data.getFirstVersion() != null && data.getFirstVersion().getContent() != null) {
            return data.getFirstVersion().getContent().getContentType();
        }
        return null;
    }

    private ContentHandle getContent(CreateArtifact data) {
        if (data.getFirstVersion() != null && data.getFirstVersion().getContent() != null) {
            return ContentHandle.create((String)data.getFirstVersion().getContent().getContent());
        }
        return null;
    }

    private List<ArtifactReference> getReferences(CreateArtifact data) {
        if (data.getFirstVersion() != null && data.getFirstVersion().getContent() != null) {
            return data.getFirstVersion().getContent().getReferences();
        }
        return null;
    }

    private static void requireParameter(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            throw new MissingRequiredParameterException(parameterName);
        }
    }

    private CreateArtifactResponse handleIfExists(String groupId, String artifactId, IfArtifactExists ifExists, CreateVersion theVersion, boolean canonical) {
        if (ifExists == null || theVersion == null) {
            ifExists = IfArtifactExists.FAIL;
        }
        switch (ifExists) {
            case CREATE_VERSION: {
                return this.updateArtifactInternal(groupId, artifactId, theVersion);
            }
            case FIND_OR_CREATE_VERSION: {
                return this.handleIfExistsReturnOrUpdate(groupId, artifactId, theVersion, canonical);
            }
        }
        throw new ArtifactAlreadyExistsException(groupId, artifactId);
    }

    private CreateArtifactResponse handleIfExistsReturnOrUpdate(String groupId, String artifactId, CreateVersion theVersion, boolean canonical) {
        try {
            TypedContent content = TypedContent.create((ContentHandle)ContentHandle.create((String)theVersion.getContent().getContent()), (String)theVersion.getContent().getContentType());
            List<ArtifactReferenceDto> referenceDtos = this.toReferenceDtos(theVersion.getContent().getReferences());
            ArtifactVersionMetaDataDto vmdDto = this.storage.getArtifactVersionMetaDataByContent(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, canonical, content, referenceDtos);
            VersionMetaData vmd = V3ApiUtil.dtoToVersionMetaData(vmdDto);
            ArtifactMetaDataDto amdDto = this.storage.getArtifactMetaData(groupId, artifactId);
            ArtifactMetaData amd = V3ApiUtil.dtoToArtifactMetaData(amdDto);
            return ((CreateArtifactResponse.CreateArtifactResponseBuilder)((CreateArtifactResponse.CreateArtifactResponseBuilder)CreateArtifactResponse.builder().artifact(amd)).version(vmd)).build();
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            return this.updateArtifactInternal(groupId, artifactId, theVersion);
        }
    }

    private CreateArtifactResponse updateArtifactInternal(String groupId, String artifactId, CreateVersion theVersion) {
        String version = theVersion.getVersion();
        String name = theVersion.getName();
        String description = theVersion.getDescription();
        List<String> branches = theVersion.getBranches();
        Map<String, String> labels = theVersion.getLabels();
        List<ArtifactReference> references = theVersion.getContent().getReferences();
        String contentType = theVersion.getContent().getContentType();
        ContentHandle content = ContentHandle.create((String)theVersion.getContent().getContent());
        String artifactType = this.lookupArtifactType(groupId, artifactId);
        List<ArtifactReferenceDto> referencesAsDtos = this.toReferenceDtos(references);
        Map<String, TypedContent> resolvedReferences = RegistryContentUtils.recursivelyResolveReferences(referencesAsDtos, this.storage::getContentByReference);
        TypedContent typedContent = TypedContent.create((ContentHandle)content, (String)contentType);
        this.rulesService.applyRules(new GroupId(groupId).getRawGroupIdWithNull(), artifactId, artifactType, typedContent, RuleApplicationType.UPDATE, references, resolvedReferences);
        EditableVersionMetaDataDto metaData = EditableVersionMetaDataDto.builder().name(name).description(description).labels(labels).build();
        ContentWrapperDto contentDto = ContentWrapperDto.builder().contentType(contentType).content(content).references(referencesAsDtos).build();
        ArtifactVersionMetaDataDto vmdDto = this.storage.createArtifactVersion(groupId, artifactId, version, artifactType, contentDto, metaData, branches, false);
        VersionMetaData vmd = V3ApiUtil.dtoToVersionMetaData(vmdDto);
        ArtifactMetaDataDto amdDto = this.storage.getArtifactMetaData(groupId, artifactId);
        ArtifactMetaData amd = V3ApiUtil.dtoToArtifactMetaData(amdDto);
        return ((CreateArtifactResponse.CreateArtifactResponseBuilder)((CreateArtifactResponse.CreateArtifactResponseBuilder)CreateArtifactResponse.builder().artifact(amd)).version(vmd)).build();
    }

    private List<ArtifactReferenceDto> toReferenceDtos(List<ArtifactReference> references) {
        if (references == null) {
            references = Collections.emptyList();
        }
        return references.stream().peek(r -> r.setGroupId(new GroupId(r.getGroupId()).getRawGroupIdWithNull())).map(V3ApiUtil::referenceToDto).collect(Collectors.toList());
    }

    private InputStream fetchContentFromURL(Client client, URI url) {
        try {
            List contentLengthHeaders = (List)client.target(url).request().head().getHeaders().get((Object)"Content-Length");
            if (contentLengthHeaders == null || contentLengthHeaders.size() < 1) {
                throw new BadRequestException("Requested resource URL does not provide 'Content-Length' in the headers");
            }
            int contentLength = Integer.parseInt(contentLengthHeaders.get(0).toString());
            if (contentLength > this.restConfig.getDownloadMaxSize()) {
                throw new BadRequestException("Requested resource is bigger than " + this.restConfig.getDownloadMaxSize() + " and cannot be downloaded.");
            }
            if (contentLength <= 0) {
                throw new BadRequestException("Requested resource URL is providing 'Content-Length' <= 0.");
            }
            return new BufferedInputStream((InputStream)client.target(url).request().get().readEntity(InputStream.class), contentLength);
        }
        catch (BadRequestException bre) {
            throw bre;
        }
        catch (Exception e) {
            throw new BadRequestException("Errors downloading the artifact content.", (Throwable)e);
        }
    }

    public static enum RegistryHashAlgorithm {
        SHA256,
        MD5;

    }
}

