/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v3;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.HeadersHack;
import io.apicurio.registry.rest.v3.AbstractResourceImpl;
import io.apicurio.registry.rest.v3.IdsResource;
import io.apicurio.registry.rest.v3.V3ApiUtil;
import io.apicurio.registry.rest.v3.beans.ArtifactReference;
import io.apicurio.registry.rest.v3.beans.HandleReferencesType;
import io.apicurio.registry.rest.v3.shared.CommonResourceOperations;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.types.ArtifactMediaTypes;
import io.apicurio.registry.types.ReferenceType;
import io.apicurio.registry.types.VersionState;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class IdsResourceImpl
extends AbstractResourceImpl
implements IdsResource {
    @Inject
    CommonResourceOperations common;

    private void checkIfDeprecated(Supplier<VersionState> stateSupplier, String artifactId, String version, Response.ResponseBuilder builder) {
        HeadersHack.checkIfDeprecated(stateSupplier, null, artifactId, version, builder);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public Response getContentById(long contentId) {
        ContentHandle content = this.storage.getContentById(contentId).getContent();
        Response.ResponseBuilder builder = Response.ok((Object)content, (MediaType)ArtifactMediaTypes.BINARY);
        return builder.build();
    }

    @Override
    @Authorized(style=AuthorizedStyle.GlobalId, level=AuthorizedLevel.Read)
    public Response getContentByGlobalId(long globalId, HandleReferencesType references) {
        ArtifactVersionMetaDataDto metaData = this.storage.getArtifactVersionMetaData(globalId);
        if (VersionState.DISABLED.equals((Object)metaData.getState())) {
            throw new ArtifactNotFoundException(null, String.valueOf(globalId));
        }
        if (references == null) {
            references = HandleReferencesType.PRESERVE;
        }
        StoredArtifactVersionDto artifact = this.storage.getArtifactVersionContent(globalId);
        TypedContent contentToReturn = TypedContent.create((ContentHandle)artifact.getContent(), (String)artifact.getContentType());
        contentToReturn = this.handleContentReferences(references, metaData.getArtifactType(), contentToReturn, artifact.getReferences());
        Response.ResponseBuilder builder = Response.ok((Object)contentToReturn.getContent(), (String)contentToReturn.getContentType());
        this.checkIfDeprecated(metaData::getState, metaData.getArtifactId(), metaData.getVersion(), builder);
        return builder.build();
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public Response getContentByHash(String contentHash) {
        ContentHandle content = this.storage.getContentByHash(contentHash).getContent();
        Response.ResponseBuilder builder = Response.ok((Object)content, (MediaType)ArtifactMediaTypes.BINARY);
        return builder.build();
    }

    @Override
    public List<ArtifactReference> referencesByContentHash(String contentHash) {
        return this.common.getReferencesByContentHash(contentHash);
    }

    @Override
    public List<ArtifactReference> referencesByContentId(long contentId) {
        ContentWrapperDto artifact = this.storage.getContentById(contentId);
        return artifact.getReferences().stream().map(V3ApiUtil::referenceDtoToReference).collect(Collectors.toList());
    }

    @Override
    public List<ArtifactReference> referencesByGlobalId(long globalId, ReferenceType refType) {
        if (refType == ReferenceType.OUTBOUND || refType == null) {
            StoredArtifactVersionDto artifact = this.storage.getArtifactVersionContent(globalId);
            return artifact.getReferences().stream().map(V3ApiUtil::referenceDtoToReference).collect(Collectors.toList());
        }
        ArtifactVersionMetaDataDto vmd = this.storage.getArtifactVersionMetaData(globalId);
        return this.storage.getInboundArtifactReferences(vmd.getGroupId(), vmd.getArtifactId(), vmd.getVersion()).stream().map(V3ApiUtil::referenceDtoToReference).collect(Collectors.toList());
    }
}

