/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v3;

import io.apicurio.common.apps.core.System;
import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.limits.RegistryLimitsConfiguration;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.RestConfig;
import io.apicurio.registry.rest.v3.SystemResource;
import io.apicurio.registry.rest.v3.beans.Limits;
import io.apicurio.registry.rest.v3.beans.SystemInfo;
import io.apicurio.registry.rest.v3.beans.UserInterfaceConfig;
import io.apicurio.registry.rest.v3.beans.UserInterfaceConfigAuth;
import io.apicurio.registry.rest.v3.beans.UserInterfaceConfigFeatures;
import io.apicurio.registry.rest.v3.beans.UserInterfaceConfigUi;
import io.apicurio.registry.ui.UserInterfaceConfigProperties;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import java.util.HashMap;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SystemResourceImpl
implements SystemResource {
    @Inject
    System system;
    @Inject
    AuthConfig authConfig;
    @Inject
    UserInterfaceConfigProperties uiConfig;
    @Inject
    RegistryLimitsConfiguration registryLimitsConfiguration;
    @Inject
    RestConfig restConfig;

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.None)
    public SystemInfo getSystemInfo() {
        SystemInfo info = new SystemInfo();
        info.setName(this.system.getName());
        info.setDescription(this.system.getDescription());
        info.setVersion(this.system.getVersion());
        info.setBuiltOn(this.system.getDate());
        return info;
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.None)
    public Limits getResourceLimits() {
        RegistryLimitsConfiguration limitsConfig = this.registryLimitsConfiguration;
        Limits limits = new Limits();
        limits.setMaxTotalSchemasCount(limitsConfig.getMaxTotalSchemasCount());
        limits.setMaxSchemaSizeBytes(limitsConfig.getMaxSchemaSizeBytes());
        limits.setMaxArtifactsCount(limitsConfig.getMaxArtifactsCount());
        limits.setMaxVersionsPerArtifactCount(limitsConfig.getMaxVersionsPerArtifactCount());
        limits.setMaxArtifactPropertiesCount(limitsConfig.getMaxArtifactPropertiesCount());
        limits.setMaxPropertyKeySizeBytes(limitsConfig.getMaxPropertyKeySizeBytes());
        limits.setMaxPropertyValueSizeBytes(limitsConfig.getMaxPropertyValueSizeBytes());
        limits.setMaxArtifactLabelsCount(limitsConfig.getMaxArtifactLabelsCount());
        limits.setMaxLabelSizeBytes(limitsConfig.getMaxLabelSizeBytes());
        limits.setMaxArtifactNameLengthChars(limitsConfig.getMaxArtifactNameLengthChars());
        limits.setMaxArtifactDescriptionLengthChars(limitsConfig.getMaxArtifactDescriptionLengthChars());
        limits.setMaxRequestsPerSecondCount(limitsConfig.getMaxRequestsPerSecondCount());
        return limits;
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.None)
    public UserInterfaceConfig getUIConfig() {
        return ((UserInterfaceConfig.UserInterfaceConfigBuilder)((UserInterfaceConfig.UserInterfaceConfigBuilder)((UserInterfaceConfig.UserInterfaceConfigBuilder)UserInterfaceConfig.builder().ui((UserInterfaceConfigUi)((UserInterfaceConfigUi.UserInterfaceConfigUiBuilder)((UserInterfaceConfigUi.UserInterfaceConfigUiBuilder)((UserInterfaceConfigUi.UserInterfaceConfigUiBuilder)UserInterfaceConfigUi.builder().contextPath(this.uiConfig.contextPath)).navPrefixPath(this.uiConfig.navPrefixPath)).oaiDocsUrl(this.uiConfig.docsUrl)).build())).auth(this.uiAuthConfig())).features((UserInterfaceConfigFeatures)((UserInterfaceConfigFeatures.UserInterfaceConfigFeaturesBuilder)((UserInterfaceConfigFeatures.UserInterfaceConfigFeaturesBuilder)((UserInterfaceConfigFeatures.UserInterfaceConfigFeaturesBuilder)((UserInterfaceConfigFeatures.UserInterfaceConfigFeaturesBuilder)((UserInterfaceConfigFeatures.UserInterfaceConfigFeaturesBuilder)((UserInterfaceConfigFeatures.UserInterfaceConfigFeaturesBuilder)((UserInterfaceConfigFeatures.UserInterfaceConfigFeaturesBuilder)UserInterfaceConfigFeatures.builder().readOnly("true".equals(this.uiConfig.featureReadOnly))).breadcrumbs("true".equals(this.uiConfig.featureBreadcrumbs))).roleManagement(this.authConfig.isRbacEnabled())).deleteGroup(this.restConfig.isGroupDeletionEnabled())).deleteArtifact(this.restConfig.isArtifactDeletionEnabled())).deleteVersion(this.restConfig.isArtifactVersionDeletionEnabled())).settings("true".equals(this.uiConfig.featureSettings))).build())).build();
    }

    private UserInterfaceConfigAuth uiAuthConfig() {
        UserInterfaceConfigAuth rval = new UserInterfaceConfigAuth();
        rval.setObacEnabled(this.authConfig.isObacEnabled());
        rval.setRbacEnabled(this.authConfig.isRbacEnabled());
        rval.setType(this.authConfig.isOidcAuthEnabled() ? UserInterfaceConfigAuth.Type.oidc : (this.authConfig.isBasicAuthEnabled() ? UserInterfaceConfigAuth.Type.basic : UserInterfaceConfigAuth.Type.none));
        if (this.authConfig.isOidcAuthEnabled()) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("url", this.uiConfig.authOidcUrl);
            options.put("redirectUri", this.uiConfig.authOidcRedirectUri);
            options.put("clientId", this.uiConfig.authOidcClientId);
            if (!"f5".equals(this.uiConfig.authOidcLogoutUrl)) {
                options.put("logoutUrl", this.uiConfig.authOidcLogoutUrl);
            }
            rval.setOptions(options);
        }
        return rval;
    }
}

