/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v3;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.auth.AdminOverride;
import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.auth.RoleBasedAccessController;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.v3.UsersResource;
import io.apicurio.registry.rest.v3.beans.UserInfo;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import org.slf4j.Logger;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class UsersResourceImpl
implements UsersResource {
    @Inject
    Logger log;
    @Inject
    AuthConfig authConfig;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    RoleBasedAccessController rbac;
    @Inject
    AdminOverride adminOverride;

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.None)
    public UserInfo getCurrentUserInfo() {
        UserInfo info = new UserInfo();
        info.setUsername(this.securityIdentity.getPrincipal().getName());
        info.setDisplayName(this.securityIdentity.getPrincipal().getName());
        if (this.authConfig.isRbacEnabled()) {
            info.setAdmin(this.rbac.isAdmin());
            info.setDeveloper(this.rbac.isDeveloper());
            info.setViewer(this.rbac.isReadOnly());
        } else {
            info.setAdmin(true);
            info.setDeveloper(false);
            info.setViewer(false);
        }
        if (this.authConfig.isAdminOverrideEnabled() && this.adminOverride.isAdmin()) {
            info.setAdmin(true);
        }
        if (this.securityIdentity.isAnonymous() && this.authConfig.isAnonymousReadsEnabled()) {
            info.setViewer(true);
        }
        if (!this.securityIdentity.isAnonymous() && this.authConfig.isAuthenticatedReadsEnabled()) {
            info.setViewer(true);
        }
        return info;
    }
}

