/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.rest.v3.beans.ArtifactReference;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleContext;
import io.apicurio.registry.rules.RuleExecutor;
import io.apicurio.registry.rules.RuleExecutorFactory;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesProperties;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.LazyContentList;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ApplicationScoped
public class RulesServiceImpl
implements RulesService {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RuleExecutorFactory factory;
    @Inject
    RulesProperties rulesProperties;
    @Inject
    ArtifactTypeUtilProviderFactory providerFactory;

    @Override
    public void applyRules(String groupId, String artifactId, String artifactType, TypedContent content, RuleApplicationType ruleApplicationType, List<ArtifactReference> references, Map<String, TypedContent> resolvedReferences) throws RuleViolationException {
        HashSet<RuleType> artifactRules = Collections.EMPTY_SET;
        if (ruleApplicationType == RuleApplicationType.UPDATE) {
            artifactRules = new HashSet<RuleType>(this.storage.getArtifactRules(groupId, artifactId));
        }
        LazyContentList currentContent = null;
        currentContent = ruleApplicationType == RuleApplicationType.UPDATE ? new LazyContentList(this.storage, this.storage.getEnabledArtifactContentIds(groupId, artifactId)) : new LazyContentList(this.storage, Collections.emptyList());
        this.applyAllRules(groupId, artifactId, artifactType, currentContent, content, artifactRules, references, resolvedReferences);
    }

    private void applyAllRules(String groupId, String artifactId, String artifactType, List<TypedContent> currentContent, TypedContent updatedContent, Set<RuleType> artifactRules, List<ArtifactReference> references, Map<String, TypedContent> resolvedReferences) {
        HashMap allRules = new HashMap();
        HashSet<RuleType> groupRules = this.storage.isGroupExists(groupId) ? new HashSet<RuleType>(this.storage.getGroupRules(groupId)) : Set.of();
        HashSet<RuleType> globalRules = new HashSet<RuleType>(this.storage.getGlobalRules());
        Set<RuleType> defaultGlobalRules = this.rulesProperties.getDefaultGlobalRules();
        List.of(RuleType.values()).forEach(rt -> {
            if (artifactRules.contains(rt)) {
                allRules.put(rt, this.storage.getArtifactRule(groupId, artifactId, (RuleType)((Object)rt)));
            } else if (groupRules.contains(rt)) {
                allRules.put(rt, this.storage.getGroupRule(groupId, (RuleType)((Object)rt)));
            } else if (globalRules.contains(rt)) {
                allRules.put(rt, this.storage.getGlobalRule((RuleType)((Object)rt)));
            } else if (defaultGlobalRules.contains(rt)) {
                allRules.put(rt, this.rulesProperties.getDefaultGlobalRuleConfiguration((RuleType)((Object)rt)));
            }
        });
        for (RuleType ruleType : allRules.keySet()) {
            this.applyRule(groupId, artifactId, artifactType, currentContent, updatedContent, ruleType, ((RuleConfigurationDto)allRules.get((Object)ruleType)).getConfiguration(), references, resolvedReferences);
        }
    }

    @Override
    public void applyRule(String groupId, String artifactId, String artifactType, TypedContent content, RuleType ruleType, String ruleConfiguration, RuleApplicationType ruleApplicationType, List<ArtifactReference> references, Map<String, TypedContent> resolvedReferences) throws RuleViolationException {
        LazyContentList currentContent = null;
        if (ruleApplicationType == RuleApplicationType.UPDATE) {
            currentContent = new LazyContentList(this.storage, this.storage.getEnabledArtifactContentIds(groupId, artifactId));
        }
        this.applyRule(groupId, artifactId, artifactType, currentContent, content, ruleType, ruleConfiguration, references, resolvedReferences);
    }

    private void applyRule(String groupId, String artifactId, String artifactType, List<TypedContent> currentContent, TypedContent updatedContent, RuleType ruleType, String ruleConfiguration, List<ArtifactReference> references, Map<String, TypedContent> resolvedReferences) {
        RuleExecutor executor = this.factory.createExecutor(ruleType);
        RuleContext context = RuleContext.builder().groupId(groupId).artifactId(artifactId).artifactType(artifactType).currentContent(currentContent).updatedContent(updatedContent).configuration(ruleConfiguration).references(references).resolvedReferences(resolvedReferences).build();
        executor.execute(context);
    }

    @Override
    public void applyRules(String groupId, String artifactId, String artifactVersion, String artifactType, TypedContent updatedContent, List<ArtifactReference> references, Map<String, TypedContent> resolvedReferences) throws RuleViolationException {
        StoredArtifactVersionDto versionContent = this.storage.getArtifactVersionContent(groupId, artifactId, artifactVersion);
        TypedContent typedVersionContent = TypedContent.create((ContentHandle)versionContent.getContent(), (String)versionContent.getContentType());
        HashSet<RuleType> artifactRules = new HashSet<RuleType>(this.storage.getArtifactRules(groupId, artifactId));
        this.applyAllRules(groupId, artifactId, artifactType, Collections.singletonList(typedVersionContent), updatedContent, artifactRules, references, resolvedReferences);
    }
}

